/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOnlineEvaluationConfigsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOnlineEvaluationConfigsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigSummary;

public class ListOnlineEvaluationConfigsIterable
implements SdkIterable<ListOnlineEvaluationConfigsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListOnlineEvaluationConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOnlineEvaluationConfigsIterable(BedrockAgentCoreControlClient client, ListOnlineEvaluationConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOnlineEvaluationConfigsResponseFetcher();
    }

    public Iterator<ListOnlineEvaluationConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OnlineEvaluationConfigSummary> onlineEvaluationConfigs() {
        Function<ListOnlineEvaluationConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.onlineEvaluationConfigs() != null) {
                return response.onlineEvaluationConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOnlineEvaluationConfigsResponseFetcher
    implements SyncPageFetcher<ListOnlineEvaluationConfigsResponse> {
        private ListOnlineEvaluationConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListOnlineEvaluationConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOnlineEvaluationConfigsResponse nextPage(ListOnlineEvaluationConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListOnlineEvaluationConfigsIterable.this.client.listOnlineEvaluationConfigs(ListOnlineEvaluationConfigsIterable.this.firstRequest);
            }
            return ListOnlineEvaluationConfigsIterable.this.client.listOnlineEvaluationConfigs((ListOnlineEvaluationConfigsRequest)((Object)ListOnlineEvaluationConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

