/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationAssetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationAssetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGenerationAsset;

public class ListPolicyGenerationAssetsIterable
implements SdkIterable<ListPolicyGenerationAssetsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListPolicyGenerationAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyGenerationAssetsIterable(BedrockAgentCoreControlClient client, ListPolicyGenerationAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyGenerationAssetsResponseFetcher();
    }

    public Iterator<ListPolicyGenerationAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyGenerationAsset> policyGenerationAssets() {
        Function<ListPolicyGenerationAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGenerationAssets() != null) {
                return response.policyGenerationAssets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyGenerationAssetsResponseFetcher
    implements SyncPageFetcher<ListPolicyGenerationAssetsResponse> {
        private ListPolicyGenerationAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyGenerationAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyGenerationAssetsResponse nextPage(ListPolicyGenerationAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGenerationAssetsIterable.this.client.listPolicyGenerationAssets(ListPolicyGenerationAssetsIterable.this.firstRequest);
            }
            return ListPolicyGenerationAssetsIterable.this.client.listPolicyGenerationAssets((ListPolicyGenerationAssetsRequest)((Object)ListPolicyGenerationAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

