/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEvaluatorResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, UpdateEvaluatorResponse> {
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorArn").getter(UpdateEvaluatorResponse.getter(UpdateEvaluatorResponse::evaluatorArn)).setter(UpdateEvaluatorResponse.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorArn").build()}).build();
    private static final SdkField<String> EVALUATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorId").getter(UpdateEvaluatorResponse.getter(UpdateEvaluatorResponse::evaluatorId)).setter(UpdateEvaluatorResponse.setter(Builder::evaluatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateEvaluatorResponse.getter(UpdateEvaluatorResponse::updatedAt)).setter(UpdateEvaluatorResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateEvaluatorResponse.getter(UpdateEvaluatorResponse::statusAsString)).setter(UpdateEvaluatorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATOR_ARN_FIELD, EVALUATOR_ID_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEvaluatorResponse.memberNameToFieldInitializer();
    private final String evaluatorArn;
    private final String evaluatorId;
    private final Instant updatedAt;
    private final String status;

    private UpdateEvaluatorResponse(BuilderImpl builder) {
        super(builder);
        this.evaluatorArn = builder.evaluatorArn;
        this.evaluatorId = builder.evaluatorId;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String evaluatorId() {
        return this.evaluatorId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final EvaluatorStatus status() {
        return EvaluatorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEvaluatorResponse)) {
            return false;
        }
        UpdateEvaluatorResponse other = (UpdateEvaluatorResponse)((Object)obj);
        return Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.evaluatorId(), other.evaluatorId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEvaluatorResponse").add("EvaluatorArn", (Object)this.evaluatorArn()).add("EvaluatorId", (Object)this.evaluatorId()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "evaluatorId": {
                return Optional.ofNullable(clazz.cast(this.evaluatorId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("evaluatorId", EVALUATOR_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEvaluatorResponse, T> g) {
        return obj -> g.apply((UpdateEvaluatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String evaluatorArn;
        private String evaluatorId;
        private Instant updatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEvaluatorResponse model) {
            super(model);
            this.evaluatorArn(model.evaluatorArn);
            this.evaluatorId(model.evaluatorId);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getEvaluatorId() {
            return this.evaluatorId;
        }

        public final void setEvaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
        }

        @Override
        public final Builder evaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluatorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public UpdateEvaluatorResponse build() {
            return new UpdateEvaluatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEvaluatorResponse> {
        public Builder evaluatorArn(String var1);

        public Builder evaluatorId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(EvaluatorStatus var1);
    }
}

