/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EpisodicReflectionConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EpisodicReflectionConfigurationInput> {
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(EpisodicReflectionConfigurationInput.getter(EpisodicReflectionConfigurationInput::namespaces)).setter(EpisodicReflectionConfigurationInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EpisodicReflectionConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> namespaces;

    private EpisodicReflectionConfigurationInput(BuilderImpl builder) {
        this.namespaces = builder.namespaces;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EpisodicReflectionConfigurationInput)) {
            return false;
        }
        EpisodicReflectionConfigurationInput other = (EpisodicReflectionConfigurationInput)obj;
        return this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces());
    }

    public final String toString() {
        return ToString.builder((String)"EpisodicReflectionConfigurationInput").add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("namespaces", NAMESPACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EpisodicReflectionConfigurationInput, T> g) {
        return obj -> g.apply((EpisodicReflectionConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EpisodicReflectionConfigurationInput model) {
            this.namespaces(model.namespaces);
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public EpisodicReflectionConfigurationInput build() {
            return new EpisodicReflectionConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EpisodicReflectionConfigurationInput> {
        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);
    }
}

