/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ExceptionLevel;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayInterceptorConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayInterceptorConfigurationsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayPolicyEngineConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayProtocolConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayProtocolType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGatewayRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateGatewayRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayIdentifier").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::gatewayIdentifier)).setter(UpdateGatewayRequest.setter(Builder::gatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::name)).setter(UpdateGatewayRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::description)).setter(UpdateGatewayRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::roleArn)).setter(UpdateGatewayRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolType").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::protocolTypeAsString)).setter(UpdateGatewayRequest.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()}).build();
    private static final SdkField<GatewayProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("protocolConfiguration").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::protocolConfiguration)).setter(UpdateGatewayRequest.setter(Builder::protocolConfiguration)).constructor(GatewayProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerType").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::authorizerTypeAsString)).setter(UpdateGatewayRequest.setter(Builder::authorizerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()}).build();
    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfiguration").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::authorizerConfiguration)).setter(UpdateGatewayRequest.setter(Builder::authorizerConfiguration)).constructor(AuthorizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::kmsKeyArn)).setter(UpdateGatewayRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<List<GatewayInterceptorConfiguration>> INTERCEPTOR_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("interceptorConfigurations").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::interceptorConfigurations)).setter(UpdateGatewayRequest.setter(Builder::interceptorConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interceptorConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GatewayInterceptorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GatewayPolicyEngineConfiguration> POLICY_ENGINE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyEngineConfiguration").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::policyEngineConfiguration)).setter(UpdateGatewayRequest.setter(Builder::policyEngineConfiguration)).constructor(GatewayPolicyEngineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyEngineConfiguration").build()}).build();
    private static final SdkField<String> EXCEPTION_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exceptionLevel").getter(UpdateGatewayRequest.getter(UpdateGatewayRequest::exceptionLevelAsString)).setter(UpdateGatewayRequest.setter(Builder::exceptionLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, PROTOCOL_TYPE_FIELD, PROTOCOL_CONFIGURATION_FIELD, AUTHORIZER_TYPE_FIELD, AUTHORIZER_CONFIGURATION_FIELD, KMS_KEY_ARN_FIELD, INTERCEPTOR_CONFIGURATIONS_FIELD, POLICY_ENGINE_CONFIGURATION_FIELD, EXCEPTION_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGatewayRequest.memberNameToFieldInitializer();
    private final String gatewayIdentifier;
    private final String name;
    private final String description;
    private final String roleArn;
    private final String protocolType;
    private final GatewayProtocolConfiguration protocolConfiguration;
    private final String authorizerType;
    private final AuthorizerConfiguration authorizerConfiguration;
    private final String kmsKeyArn;
    private final List<GatewayInterceptorConfiguration> interceptorConfigurations;
    private final GatewayPolicyEngineConfiguration policyEngineConfiguration;
    private final String exceptionLevel;

    private UpdateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.protocolType = builder.protocolType;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.authorizerType = builder.authorizerType;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.interceptorConfigurations = builder.interceptorConfigurations;
        this.policyEngineConfiguration = builder.policyEngineConfiguration;
        this.exceptionLevel = builder.exceptionLevel;
    }

    public final String gatewayIdentifier() {
        return this.gatewayIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final GatewayProtocolType protocolType() {
        return GatewayProtocolType.fromValue(this.protocolType);
    }

    public final String protocolTypeAsString() {
        return this.protocolType;
    }

    public final GatewayProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(this.authorizerType);
    }

    public final String authorizerTypeAsString() {
        return this.authorizerType;
    }

    public final AuthorizerConfiguration authorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasInterceptorConfigurations() {
        return this.interceptorConfigurations != null && !(this.interceptorConfigurations instanceof SdkAutoConstructList);
    }

    public final List<GatewayInterceptorConfiguration> interceptorConfigurations() {
        return this.interceptorConfigurations;
    }

    public final GatewayPolicyEngineConfiguration policyEngineConfiguration() {
        return this.policyEngineConfiguration;
    }

    public final ExceptionLevel exceptionLevel() {
        return ExceptionLevel.fromValue(this.exceptionLevel);
    }

    public final String exceptionLevelAsString() {
        return this.exceptionLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterceptorConfigurations() ? this.interceptorConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEngineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.exceptionLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayRequest)) {
            return false;
        }
        UpdateGatewayRequest other = (UpdateGatewayRequest)((Object)obj);
        return Objects.equals(this.gatewayIdentifier(), other.gatewayIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && Objects.equals(this.authorizerTypeAsString(), other.authorizerTypeAsString()) && Objects.equals(this.authorizerConfiguration(), other.authorizerConfiguration()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasInterceptorConfigurations() == other.hasInterceptorConfigurations() && Objects.equals(this.interceptorConfigurations(), other.interceptorConfigurations()) && Objects.equals(this.policyEngineConfiguration(), other.policyEngineConfiguration()) && Objects.equals(this.exceptionLevelAsString(), other.exceptionLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGatewayRequest").add("GatewayIdentifier", (Object)this.gatewayIdentifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("ProtocolType", (Object)this.protocolTypeAsString()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("AuthorizerType", (Object)this.authorizerTypeAsString()).add("AuthorizerConfiguration", (Object)this.authorizerConfiguration()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("InterceptorConfigurations", this.hasInterceptorConfigurations() ? this.interceptorConfigurations() : null).add("PolicyEngineConfiguration", (Object)this.policyEngineConfiguration()).add("ExceptionLevel", (Object)this.exceptionLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.gatewayIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "protocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
            case "protocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "authorizerType": {
                return Optional.ofNullable(clazz.cast(this.authorizerTypeAsString()));
            }
            case "authorizerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfiguration()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "interceptorConfigurations": {
                return Optional.ofNullable(clazz.cast(this.interceptorConfigurations()));
            }
            case "policyEngineConfiguration": {
                return Optional.ofNullable(clazz.cast(this.policyEngineConfiguration()));
            }
            case "exceptionLevel": {
                return Optional.ofNullable(clazz.cast(this.exceptionLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("protocolType", PROTOCOL_TYPE_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("authorizerType", AUTHORIZER_TYPE_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("interceptorConfigurations", INTERCEPTOR_CONFIGURATIONS_FIELD);
        map.put("policyEngineConfiguration", POLICY_ENGINE_CONFIGURATION_FIELD);
        map.put("exceptionLevel", EXCEPTION_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayRequest, T> g) {
        return obj -> g.apply((UpdateGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String gatewayIdentifier;
        private String name;
        private String description;
        private String roleArn;
        private String protocolType;
        private GatewayProtocolConfiguration protocolConfiguration;
        private String authorizerType;
        private AuthorizerConfiguration authorizerConfiguration;
        private String kmsKeyArn;
        private List<GatewayInterceptorConfiguration> interceptorConfigurations = DefaultSdkAutoConstructList.getInstance();
        private GatewayPolicyEngineConfiguration policyEngineConfiguration;
        private String exceptionLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayRequest model) {
            super(model);
            this.gatewayIdentifier(model.gatewayIdentifier);
            this.name(model.name);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.protocolType(model.protocolType);
            this.protocolConfiguration(model.protocolConfiguration);
            this.authorizerType(model.authorizerType);
            this.authorizerConfiguration(model.authorizerConfiguration);
            this.kmsKeyArn(model.kmsKeyArn);
            this.interceptorConfigurations(model.interceptorConfigurations);
            this.policyEngineConfiguration(model.policyEngineConfiguration);
            this.exceptionLevel(model.exceptionLevel);
        }

        public final String getGatewayIdentifier() {
            return this.gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getProtocolType() {
            return this.protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(GatewayProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public final GatewayProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(GatewayProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(GatewayProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getAuthorizerType() {
            return this.authorizerType;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return this.authorizerConfiguration != null ? this.authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final List<GatewayInterceptorConfiguration.Builder> getInterceptorConfigurations() {
            List<GatewayInterceptorConfiguration.Builder> result = GatewayInterceptorConfigurationsCopier.copyToBuilder(this.interceptorConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterceptorConfigurations(Collection<GatewayInterceptorConfiguration.BuilderImpl> interceptorConfigurations) {
            this.interceptorConfigurations = GatewayInterceptorConfigurationsCopier.copyFromBuilder(interceptorConfigurations);
        }

        @Override
        public final Builder interceptorConfigurations(Collection<GatewayInterceptorConfiguration> interceptorConfigurations) {
            this.interceptorConfigurations = GatewayInterceptorConfigurationsCopier.copy(interceptorConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interceptorConfigurations(GatewayInterceptorConfiguration ... interceptorConfigurations) {
            this.interceptorConfigurations(Arrays.asList(interceptorConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interceptorConfigurations(Consumer<GatewayInterceptorConfiguration.Builder> ... interceptorConfigurations) {
            this.interceptorConfigurations(Stream.of(interceptorConfigurations).map(c -> (GatewayInterceptorConfiguration)((GatewayInterceptorConfiguration.Builder)GatewayInterceptorConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GatewayPolicyEngineConfiguration.Builder getPolicyEngineConfiguration() {
            return this.policyEngineConfiguration != null ? this.policyEngineConfiguration.toBuilder() : null;
        }

        public final void setPolicyEngineConfiguration(GatewayPolicyEngineConfiguration.BuilderImpl policyEngineConfiguration) {
            this.policyEngineConfiguration = policyEngineConfiguration != null ? policyEngineConfiguration.build() : null;
        }

        @Override
        public final Builder policyEngineConfiguration(GatewayPolicyEngineConfiguration policyEngineConfiguration) {
            this.policyEngineConfiguration = policyEngineConfiguration;
            return this;
        }

        public final String getExceptionLevel() {
            return this.exceptionLevel;
        }

        public final void setExceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
        }

        @Override
        public final Builder exceptionLevel(String exceptionLevel) {
            this.exceptionLevel = exceptionLevel;
            return this;
        }

        @Override
        public final Builder exceptionLevel(ExceptionLevel exceptionLevel) {
            this.exceptionLevel(exceptionLevel == null ? null : exceptionLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayRequest build() {
            return new UpdateGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGatewayRequest> {
        public Builder gatewayIdentifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder protocolType(String var1);

        public Builder protocolType(GatewayProtocolType var1);

        public Builder protocolConfiguration(GatewayProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<GatewayProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((GatewayProtocolConfiguration)((GatewayProtocolConfiguration.Builder)GatewayProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder authorizerType(String var1);

        public Builder authorizerType(AuthorizerType var1);

        public Builder authorizerConfiguration(AuthorizerConfiguration var1);

        default public Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return this.authorizerConfiguration((AuthorizerConfiguration)((AuthorizerConfiguration.Builder)AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder interceptorConfigurations(Collection<GatewayInterceptorConfiguration> var1);

        public Builder interceptorConfigurations(GatewayInterceptorConfiguration ... var1);

        public Builder interceptorConfigurations(Consumer<GatewayInterceptorConfiguration.Builder> ... var1);

        public Builder policyEngineConfiguration(GatewayPolicyEngineConfiguration var1);

        default public Builder policyEngineConfiguration(Consumer<GatewayPolicyEngineConfiguration.Builder> policyEngineConfiguration) {
            return this.policyEngineConfiguration((GatewayPolicyEngineConfiguration)((GatewayPolicyEngineConfiguration.Builder)GatewayPolicyEngineConfiguration.builder().applyMutation(policyEngineConfiguration)).build());
        }

        public Builder exceptionLevel(String var1);

        public Builder exceptionLevel(ExceptionLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

