/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiGatewayToolFilter;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiGatewayToolFiltersCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiGatewayToolOverride;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiGatewayToolOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiGatewayToolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiGatewayToolConfiguration> {
    private static final SdkField<List<ApiGatewayToolOverride>> TOOL_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("toolOverrides").getter(ApiGatewayToolConfiguration.getter(ApiGatewayToolConfiguration::toolOverrides)).setter(ApiGatewayToolConfiguration.setter(Builder::toolOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiGatewayToolOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ApiGatewayToolFilter>> TOOL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("toolFilters").getter(ApiGatewayToolConfiguration.getter(ApiGatewayToolConfiguration::toolFilters)).setter(ApiGatewayToolConfiguration.setter(Builder::toolFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiGatewayToolFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_OVERRIDES_FIELD, TOOL_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiGatewayToolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ApiGatewayToolOverride> toolOverrides;
    private final List<ApiGatewayToolFilter> toolFilters;

    private ApiGatewayToolConfiguration(BuilderImpl builder) {
        this.toolOverrides = builder.toolOverrides;
        this.toolFilters = builder.toolFilters;
    }

    public final boolean hasToolOverrides() {
        return this.toolOverrides != null && !(this.toolOverrides instanceof SdkAutoConstructList);
    }

    public final List<ApiGatewayToolOverride> toolOverrides() {
        return this.toolOverrides;
    }

    public final boolean hasToolFilters() {
        return this.toolFilters != null && !(this.toolFilters instanceof SdkAutoConstructList);
    }

    public final List<ApiGatewayToolFilter> toolFilters() {
        return this.toolFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToolOverrides() ? this.toolOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToolFilters() ? this.toolFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayToolConfiguration)) {
            return false;
        }
        ApiGatewayToolConfiguration other = (ApiGatewayToolConfiguration)obj;
        return this.hasToolOverrides() == other.hasToolOverrides() && Objects.equals(this.toolOverrides(), other.toolOverrides()) && this.hasToolFilters() == other.hasToolFilters() && Objects.equals(this.toolFilters(), other.toolFilters());
    }

    public final String toString() {
        return ToString.builder((String)"ApiGatewayToolConfiguration").add("ToolOverrides", this.hasToolOverrides() ? this.toolOverrides() : null).add("ToolFilters", this.hasToolFilters() ? this.toolFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toolOverrides": {
                return Optional.ofNullable(clazz.cast(this.toolOverrides()));
            }
            case "toolFilters": {
                return Optional.ofNullable(clazz.cast(this.toolFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("toolOverrides", TOOL_OVERRIDES_FIELD);
        map.put("toolFilters", TOOL_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayToolConfiguration, T> g) {
        return obj -> g.apply((ApiGatewayToolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ApiGatewayToolOverride> toolOverrides = DefaultSdkAutoConstructList.getInstance();
        private List<ApiGatewayToolFilter> toolFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayToolConfiguration model) {
            this.toolOverrides(model.toolOverrides);
            this.toolFilters(model.toolFilters);
        }

        public final List<ApiGatewayToolOverride.Builder> getToolOverrides() {
            List<ApiGatewayToolOverride.Builder> result = ApiGatewayToolOverridesCopier.copyToBuilder(this.toolOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolOverrides(Collection<ApiGatewayToolOverride.BuilderImpl> toolOverrides) {
            this.toolOverrides = ApiGatewayToolOverridesCopier.copyFromBuilder(toolOverrides);
        }

        @Override
        public final Builder toolOverrides(Collection<ApiGatewayToolOverride> toolOverrides) {
            this.toolOverrides = ApiGatewayToolOverridesCopier.copy(toolOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolOverrides(ApiGatewayToolOverride ... toolOverrides) {
            this.toolOverrides(Arrays.asList(toolOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolOverrides(Consumer<ApiGatewayToolOverride.Builder> ... toolOverrides) {
            this.toolOverrides(Stream.of(toolOverrides).map(c -> (ApiGatewayToolOverride)((ApiGatewayToolOverride.Builder)ApiGatewayToolOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ApiGatewayToolFilter.Builder> getToolFilters() {
            List<ApiGatewayToolFilter.Builder> result = ApiGatewayToolFiltersCopier.copyToBuilder(this.toolFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolFilters(Collection<ApiGatewayToolFilter.BuilderImpl> toolFilters) {
            this.toolFilters = ApiGatewayToolFiltersCopier.copyFromBuilder(toolFilters);
        }

        @Override
        public final Builder toolFilters(Collection<ApiGatewayToolFilter> toolFilters) {
            this.toolFilters = ApiGatewayToolFiltersCopier.copy(toolFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolFilters(ApiGatewayToolFilter ... toolFilters) {
            this.toolFilters(Arrays.asList(toolFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolFilters(Consumer<ApiGatewayToolFilter.Builder> ... toolFilters) {
            this.toolFilters(Stream.of(toolFilters).map(c -> (ApiGatewayToolFilter)((ApiGatewayToolFilter.Builder)ApiGatewayToolFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ApiGatewayToolConfiguration build() {
            return new ApiGatewayToolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiGatewayToolConfiguration> {
        public Builder toolOverrides(Collection<ApiGatewayToolOverride> var1);

        public Builder toolOverrides(ApiGatewayToolOverride ... var1);

        public Builder toolOverrides(Consumer<ApiGatewayToolOverride.Builder> ... var1);

        public Builder toolFilters(Collection<ApiGatewayToolFilter> var1);

        public Builder toolFilters(ApiGatewayToolFilter ... var1);

        public Builder toolFilters(Consumer<ApiGatewayToolFilter.Builder> ... var1);
    }
}

