/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListWorkloadIdentitiesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityType;

public class ListWorkloadIdentitiesIterable
implements SdkIterable<ListWorkloadIdentitiesResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListWorkloadIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadIdentitiesIterable(BedrockAgentCoreControlClient client, ListWorkloadIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadIdentitiesResponseFetcher();
    }

    public Iterator<ListWorkloadIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadIdentityType> workloadIdentities() {
        Function<ListWorkloadIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workloadIdentities() != null) {
                return response.workloadIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkloadIdentitiesResponseFetcher
    implements SyncPageFetcher<ListWorkloadIdentitiesResponse> {
        private ListWorkloadIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadIdentitiesResponse nextPage(ListWorkloadIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadIdentitiesIterable.this.client.listWorkloadIdentities(ListWorkloadIdentitiesIterable.this.firstRequest);
            }
            return ListWorkloadIdentitiesIterable.this.client.listWorkloadIdentities((ListWorkloadIdentitiesRequest)((Object)ListWorkloadIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

