/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExceptionLevel {
    DEBUG("DEBUG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExceptionLevel> VALUE_MAP;
    private final String value;

    private ExceptionLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExceptionLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExceptionLevel> knownValues() {
        EnumSet<ExceptionLevel> knownValues = EnumSet.allOf(ExceptionLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExceptionLevel.class, ExceptionLevel::toString);
    }
}

