/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Content;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPolicyGenerationRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, StartPolicyGenerationRequest> {
    private static final SdkField<String> POLICY_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyEngineId").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::policyEngineId)).setter(StartPolicyGenerationRequest.setter(Builder::policyEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyEngineId").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::resource)).setter(StartPolicyGenerationRequest.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<Content> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::content)).setter(StartPolicyGenerationRequest.setter(Builder::content)).constructor(Content::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::name)).setter(StartPolicyGenerationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartPolicyGenerationRequest.getter(StartPolicyGenerationRequest::clientToken)).setter(StartPolicyGenerationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENGINE_ID_FIELD, RESOURCE_FIELD, CONTENT_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartPolicyGenerationRequest.memberNameToFieldInitializer();
    private final String policyEngineId;
    private final Resource resource;
    private final Content content;
    private final String name;
    private final String clientToken;

    private StartPolicyGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.policyEngineId = builder.policyEngineId;
        this.resource = builder.resource;
        this.content = builder.content;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
    }

    public final String policyEngineId() {
        return this.policyEngineId;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Content content() {
        return this.content;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEngineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPolicyGenerationRequest)) {
            return false;
        }
        StartPolicyGenerationRequest other = (StartPolicyGenerationRequest)((Object)obj);
        return Objects.equals(this.policyEngineId(), other.policyEngineId()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartPolicyGenerationRequest").add("PolicyEngineId", (Object)this.policyEngineId()).add("Resource", (Object)this.resource()).add("Content", (Object)this.content()).add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyEngineId": {
                return Optional.ofNullable(clazz.cast(this.policyEngineId()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyEngineId", POLICY_ENGINE_ID_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPolicyGenerationRequest, T> g) {
        return obj -> g.apply((StartPolicyGenerationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String policyEngineId;
        private Resource resource;
        private Content content;
        private String name;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPolicyGenerationRequest model) {
            super(model);
            this.policyEngineId(model.policyEngineId);
            this.resource(model.resource);
            this.content(model.content);
            this.name(model.name);
            this.clientToken(model.clientToken);
        }

        public final String getPolicyEngineId() {
            return this.policyEngineId;
        }

        public final void setPolicyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
        }

        @Override
        public final Builder policyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Content.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPolicyGenerationRequest build() {
            return new StartPolicyGenerationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPolicyGenerationRequest> {
        public Builder policyEngineId(String var1);

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder content(Content var1);

        default public Builder content(Consumer<Content.Builder> content) {
            return this.content((Content)((Content.Builder)Content.builder().applyMutation(content)).build());
        }

        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

