/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EpisodicReflectionConfigurationInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NamespacesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EpisodicMemoryStrategyInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EpisodicMemoryStrategyInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EpisodicMemoryStrategyInput.getter(EpisodicMemoryStrategyInput::name)).setter(EpisodicMemoryStrategyInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EpisodicMemoryStrategyInput.getter(EpisodicMemoryStrategyInput::description)).setter(EpisodicMemoryStrategyInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(EpisodicMemoryStrategyInput.getter(EpisodicMemoryStrategyInput::namespaces)).setter(EpisodicMemoryStrategyInput.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EpisodicReflectionConfigurationInput> REFLECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reflectionConfiguration").getter(EpisodicMemoryStrategyInput.getter(EpisodicMemoryStrategyInput::reflectionConfiguration)).setter(EpisodicMemoryStrategyInput.setter(Builder::reflectionConfiguration)).constructor(EpisodicReflectionConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reflectionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NAMESPACES_FIELD, REFLECTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EpisodicMemoryStrategyInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> namespaces;
    private final EpisodicReflectionConfigurationInput reflectionConfiguration;

    private EpisodicMemoryStrategyInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.namespaces = builder.namespaces;
        this.reflectionConfiguration = builder.reflectionConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public final EpisodicReflectionConfigurationInput reflectionConfiguration() {
        return this.reflectionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reflectionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EpisodicMemoryStrategyInput)) {
            return false;
        }
        EpisodicMemoryStrategyInput other = (EpisodicMemoryStrategyInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces()) && Objects.equals(this.reflectionConfiguration(), other.reflectionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"EpisodicMemoryStrategyInput").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).add("ReflectionConfiguration", (Object)this.reflectionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
            case "reflectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reflectionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        map.put("reflectionConfiguration", REFLECTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EpisodicMemoryStrategyInput, T> g) {
        return obj -> g.apply((EpisodicMemoryStrategyInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();
        private EpisodicReflectionConfigurationInput reflectionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(EpisodicMemoryStrategyInput model) {
            this.name(model.name);
            this.description(model.description);
            this.namespaces(model.namespaces);
            this.reflectionConfiguration(model.reflectionConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = NamespacesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public final EpisodicReflectionConfigurationInput.Builder getReflectionConfiguration() {
            return this.reflectionConfiguration != null ? this.reflectionConfiguration.toBuilder() : null;
        }

        public final void setReflectionConfiguration(EpisodicReflectionConfigurationInput.BuilderImpl reflectionConfiguration) {
            this.reflectionConfiguration = reflectionConfiguration != null ? reflectionConfiguration.build() : null;
        }

        @Override
        public final Builder reflectionConfiguration(EpisodicReflectionConfigurationInput reflectionConfiguration) {
            this.reflectionConfiguration = reflectionConfiguration;
            return this;
        }

        public EpisodicMemoryStrategyInput build() {
            return new EpisodicMemoryStrategyInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EpisodicMemoryStrategyInput> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);

        public Builder reflectionConfiguration(EpisodicReflectionConfigurationInput var1);

        default public Builder reflectionConfiguration(Consumer<EpisodicReflectionConfigurationInput.Builder> reflectionConfiguration) {
            return this.reflectionConfiguration((EpisodicReflectionConfigurationInput)((EpisodicReflectionConfigurationInput.Builder)EpisodicReflectionConfigurationInput.builder().applyMutation(reflectionConfiguration)).build());
        }
    }
}

