/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeEndpoint;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimeEndpointsResponse;

public class ListAgentRuntimeEndpointsIterable
implements SdkIterable<ListAgentRuntimeEndpointsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListAgentRuntimeEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentRuntimeEndpointsIterable(BedrockAgentCoreControlClient client, ListAgentRuntimeEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentRuntimeEndpointsResponseFetcher();
    }

    public Iterator<ListAgentRuntimeEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentRuntimeEndpoint> runtimeEndpoints() {
        Function<ListAgentRuntimeEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.runtimeEndpoints() != null) {
                return response.runtimeEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentRuntimeEndpointsResponseFetcher
    implements SyncPageFetcher<ListAgentRuntimeEndpointsResponse> {
        private ListAgentRuntimeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentRuntimeEndpointsResponse nextPage(ListAgentRuntimeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimeEndpointsIterable.this.client.listAgentRuntimeEndpoints(ListAgentRuntimeEndpointsIterable.this.firstRequest);
            }
            return ListAgentRuntimeEndpointsIterable.this.client.listAgentRuntimeEndpoints((ListAgentRuntimeEndpointsRequest)((Object)ListAgentRuntimeEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

