/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CloudWatchLogsInputConfigLogGroupNamesListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CloudWatchLogsInputConfigServiceNamesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogsInputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogsInputConfig> {
    private static final SdkField<List<String>> LOG_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupNames").getter(CloudWatchLogsInputConfig.getter(CloudWatchLogsInputConfig::logGroupNames)).setter(CloudWatchLogsInputConfig.setter(Builder::logGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceNames").getter(CloudWatchLogsInputConfig.getter(CloudWatchLogsInputConfig::serviceNames)).setter(CloudWatchLogsInputConfig.setter(Builder::serviceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAMES_FIELD, SERVICE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchLogsInputConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> logGroupNames;
    private final List<String> serviceNames;

    private CloudWatchLogsInputConfig(BuilderImpl builder) {
        this.logGroupNames = builder.logGroupNames;
        this.serviceNames = builder.serviceNames;
    }

    public final boolean hasLogGroupNames() {
        return this.logGroupNames != null && !(this.logGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupNames() {
        return this.logGroupNames;
    }

    public final boolean hasServiceNames() {
        return this.serviceNames != null && !(this.serviceNames instanceof SdkAutoConstructList);
    }

    public final List<String> serviceNames() {
        return this.serviceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupNames() ? this.logGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceNames() ? this.serviceNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsInputConfig)) {
            return false;
        }
        CloudWatchLogsInputConfig other = (CloudWatchLogsInputConfig)obj;
        return this.hasLogGroupNames() == other.hasLogGroupNames() && Objects.equals(this.logGroupNames(), other.logGroupNames()) && this.hasServiceNames() == other.hasServiceNames() && Objects.equals(this.serviceNames(), other.serviceNames());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchLogsInputConfig").add("LogGroupNames", this.hasLogGroupNames() ? this.logGroupNames() : null).add("ServiceNames", this.hasServiceNames() ? this.serviceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupNames": {
                return Optional.ofNullable(clazz.cast(this.logGroupNames()));
            }
            case "serviceNames": {
                return Optional.ofNullable(clazz.cast(this.serviceNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("logGroupNames", LOG_GROUP_NAMES_FIELD);
        map.put("serviceNames", SERVICE_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsInputConfig, T> g) {
        return obj -> g.apply((CloudWatchLogsInputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> logGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsInputConfig model) {
            this.logGroupNames(model.logGroupNames);
            this.serviceNames(model.serviceNames);
        }

        public final Collection<String> getLogGroupNames() {
            if (this.logGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupNames;
        }

        public final void setLogGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = CloudWatchLogsInputConfigLogGroupNamesListCopier.copy(logGroupNames);
        }

        @Override
        public final Builder logGroupNames(Collection<String> logGroupNames) {
            this.logGroupNames = CloudWatchLogsInputConfigLogGroupNamesListCopier.copy(logGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupNames(String ... logGroupNames) {
            this.logGroupNames(Arrays.asList(logGroupNames));
            return this;
        }

        public final Collection<String> getServiceNames() {
            if (this.serviceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceNames;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = CloudWatchLogsInputConfigServiceNamesListCopier.copy(serviceNames);
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = CloudWatchLogsInputConfigServiceNamesListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String ... serviceNames) {
            this.serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public CloudWatchLogsInputConfig build() {
            return new CloudWatchLogsInputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogsInputConfig> {
        public Builder logGroupNames(Collection<String> var1);

        public Builder logGroupNames(String ... var1);

        public Builder serviceNames(Collection<String> var1);

        public Builder serviceNames(String ... var1);
    }
}

