/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationAssetsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationAssetsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGenerationAsset;

public class ListPolicyGenerationAssetsPublisher
implements SdkPublisher<ListPolicyGenerationAssetsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListPolicyGenerationAssetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyGenerationAssetsPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyGenerationAssetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyGenerationAssetsPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyGenerationAssetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyGenerationAssetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyGenerationAssetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyGenerationAsset> policyGenerationAssets() {
        Function<ListPolicyGenerationAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGenerationAssets() != null) {
                return response.policyGenerationAssets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyGenerationAssetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyGenerationAssetsResponseFetcher
    implements AsyncPageFetcher<ListPolicyGenerationAssetsResponse> {
        private ListPolicyGenerationAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyGenerationAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyGenerationAssetsResponse> nextPage(ListPolicyGenerationAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGenerationAssetsPublisher.this.client.listPolicyGenerationAssets(ListPolicyGenerationAssetsPublisher.this.firstRequest);
            }
            return ListPolicyGenerationAssetsPublisher.this.client.listPolicyGenerationAssets((ListPolicyGenerationAssetsRequest)((Object)ListPolicyGenerationAssetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

