/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyEnginesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyEnginesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyEngine;

public class ListPolicyEnginesPublisher
implements SdkPublisher<ListPolicyEnginesResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListPolicyEnginesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyEnginesPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyEnginesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyEnginesPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyEnginesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyEnginesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyEnginesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyEngine> policyEngines() {
        Function<ListPolicyEnginesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyEngines() != null) {
                return response.policyEngines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyEnginesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyEnginesResponseFetcher
    implements AsyncPageFetcher<ListPolicyEnginesResponse> {
        private ListPolicyEnginesResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyEnginesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyEnginesResponse> nextPage(ListPolicyEnginesResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyEnginesPublisher.this.client.listPolicyEngines(ListPolicyEnginesPublisher.this.firstRequest);
            }
            return ListPolicyEnginesPublisher.this.client.listPolicyEngines((ListPolicyEnginesRequest)((Object)ListPolicyEnginesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

