/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGenerationAsset;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGenerationAssetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyGenerationAssetsResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListPolicyGenerationAssetsResponse> {
    private static final SdkField<List<PolicyGenerationAsset>> POLICY_GENERATION_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyGenerationAssets").getter(ListPolicyGenerationAssetsResponse.getter(ListPolicyGenerationAssetsResponse::policyGenerationAssets)).setter(ListPolicyGenerationAssetsResponse.setter(Builder::policyGenerationAssets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationAssets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyGenerationAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyGenerationAssetsResponse.getter(ListPolicyGenerationAssetsResponse::nextToken)).setter(ListPolicyGenerationAssetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GENERATION_ASSETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPolicyGenerationAssetsResponse.memberNameToFieldInitializer();
    private final List<PolicyGenerationAsset> policyGenerationAssets;
    private final String nextToken;

    private ListPolicyGenerationAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.policyGenerationAssets = builder.policyGenerationAssets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicyGenerationAssets() {
        return this.policyGenerationAssets != null && !(this.policyGenerationAssets instanceof SdkAutoConstructList);
    }

    public final List<PolicyGenerationAsset> policyGenerationAssets() {
        return this.policyGenerationAssets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyGenerationAssets() ? this.policyGenerationAssets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGenerationAssetsResponse)) {
            return false;
        }
        ListPolicyGenerationAssetsResponse other = (ListPolicyGenerationAssetsResponse)((Object)obj);
        return this.hasPolicyGenerationAssets() == other.hasPolicyGenerationAssets() && Objects.equals(this.policyGenerationAssets(), other.policyGenerationAssets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyGenerationAssetsResponse").add("PolicyGenerationAssets", this.hasPolicyGenerationAssets() ? this.policyGenerationAssets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyGenerationAssets": {
                return Optional.ofNullable(clazz.cast(this.policyGenerationAssets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyGenerationAssets", POLICY_GENERATION_ASSETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGenerationAssetsResponse, T> g) {
        return obj -> g.apply((ListPolicyGenerationAssetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<PolicyGenerationAsset> policyGenerationAssets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGenerationAssetsResponse model) {
            super(model);
            this.policyGenerationAssets(model.policyGenerationAssets);
            this.nextToken(model.nextToken);
        }

        public final List<PolicyGenerationAsset.Builder> getPolicyGenerationAssets() {
            List<PolicyGenerationAsset.Builder> result = PolicyGenerationAssetsCopier.copyToBuilder(this.policyGenerationAssets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyGenerationAssets(Collection<PolicyGenerationAsset.BuilderImpl> policyGenerationAssets) {
            this.policyGenerationAssets = PolicyGenerationAssetsCopier.copyFromBuilder(policyGenerationAssets);
        }

        @Override
        public final Builder policyGenerationAssets(Collection<PolicyGenerationAsset> policyGenerationAssets) {
            this.policyGenerationAssets = PolicyGenerationAssetsCopier.copy(policyGenerationAssets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerationAssets(PolicyGenerationAsset ... policyGenerationAssets) {
            this.policyGenerationAssets(Arrays.asList(policyGenerationAssets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerationAssets(Consumer<PolicyGenerationAsset.Builder> ... policyGenerationAssets) {
            this.policyGenerationAssets(Stream.of(policyGenerationAssets).map(c -> (PolicyGenerationAsset)((PolicyGenerationAsset.Builder)PolicyGenerationAsset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyGenerationAssetsResponse build() {
            return new ListPolicyGenerationAssetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyGenerationAssetsResponse> {
        public Builder policyGenerationAssets(Collection<PolicyGenerationAsset> var1);

        public Builder policyGenerationAssets(PolicyGenerationAsset ... var1);

        public Builder policyGenerationAssets(Consumer<PolicyGenerationAsset.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

