/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CategoricalScaleDefinition;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CategoricalScaleDefinitionsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NumericalScaleDefinition;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NumericalScaleDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RatingScale
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RatingScale> {
    private static final SdkField<List<NumericalScaleDefinition>> NUMERICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("numerical").getter(RatingScale.getter(RatingScale::numerical)).setter(RatingScale.setter(Builder::numerical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numerical").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NumericalScaleDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CategoricalScaleDefinition>> CATEGORICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categorical").getter(RatingScale.getter(RatingScale::categorical)).setter(RatingScale.setter(Builder::categorical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categorical").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoricalScaleDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMERICAL_FIELD, CATEGORICAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RatingScale.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<NumericalScaleDefinition> numerical;
    private final List<CategoricalScaleDefinition> categorical;
    private final Type type;

    private RatingScale(BuilderImpl builder) {
        this.numerical = builder.numerical;
        this.categorical = builder.categorical;
        this.type = builder.type;
    }

    public final boolean hasNumerical() {
        return this.numerical != null && !(this.numerical instanceof SdkAutoConstructList);
    }

    public final List<NumericalScaleDefinition> numerical() {
        return this.numerical;
    }

    public final boolean hasCategorical() {
        return this.categorical != null && !(this.categorical instanceof SdkAutoConstructList);
    }

    public final List<CategoricalScaleDefinition> categorical() {
        return this.categorical;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumerical() ? this.numerical() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorical() ? this.categorical() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RatingScale)) {
            return false;
        }
        RatingScale other = (RatingScale)obj;
        return this.hasNumerical() == other.hasNumerical() && Objects.equals(this.numerical(), other.numerical()) && this.hasCategorical() == other.hasCategorical() && Objects.equals(this.categorical(), other.categorical());
    }

    public final String toString() {
        return ToString.builder((String)"RatingScale").add("Numerical", this.hasNumerical() ? this.numerical() : null).add("Categorical", this.hasCategorical() ? this.categorical() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numerical": {
                return Optional.ofNullable(clazz.cast(this.numerical()));
            }
            case "categorical": {
                return Optional.ofNullable(clazz.cast(this.categorical()));
            }
        }
        return Optional.empty();
    }

    public static RatingScale fromNumerical(List<NumericalScaleDefinition> numerical) {
        return (RatingScale)RatingScale.builder().numerical(numerical).build();
    }

    public static RatingScale fromCategorical(List<CategoricalScaleDefinition> categorical) {
        return (RatingScale)RatingScale.builder().categorical(categorical).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("numerical", NUMERICAL_FIELD);
        map.put("categorical", CATEGORICAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RatingScale, T> g) {
        return obj -> g.apply((RatingScale)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NUMERICAL,
        CATEGORICAL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<NumericalScaleDefinition> numerical = DefaultSdkAutoConstructList.getInstance();
        private List<CategoricalScaleDefinition> categorical = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RatingScale model) {
            this.numerical(model.numerical);
            this.categorical(model.categorical);
        }

        public final List<NumericalScaleDefinition.Builder> getNumerical() {
            List<NumericalScaleDefinition.Builder> result = NumericalScaleDefinitionsCopier.copyToBuilder(this.numerical);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNumerical(Collection<NumericalScaleDefinition.BuilderImpl> numerical) {
            List<NumericalScaleDefinition> oldValue = this.numerical;
            this.numerical = NumericalScaleDefinitionsCopier.copyFromBuilder(numerical);
            this.handleUnionValueChange(Type.NUMERICAL, oldValue, this.numerical);
        }

        @Override
        public final Builder numerical(Collection<NumericalScaleDefinition> numerical) {
            List<NumericalScaleDefinition> oldValue = this.numerical;
            this.numerical = NumericalScaleDefinitionsCopier.copy(numerical);
            this.handleUnionValueChange(Type.NUMERICAL, oldValue, this.numerical);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numerical(NumericalScaleDefinition ... numerical) {
            this.numerical(Arrays.asList(numerical));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numerical(Consumer<NumericalScaleDefinition.Builder> ... numerical) {
            this.numerical(Stream.of(numerical).map(c -> (NumericalScaleDefinition)((NumericalScaleDefinition.Builder)NumericalScaleDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CategoricalScaleDefinition.Builder> getCategorical() {
            List<CategoricalScaleDefinition.Builder> result = CategoricalScaleDefinitionsCopier.copyToBuilder(this.categorical);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorical(Collection<CategoricalScaleDefinition.BuilderImpl> categorical) {
            List<CategoricalScaleDefinition> oldValue = this.categorical;
            this.categorical = CategoricalScaleDefinitionsCopier.copyFromBuilder(categorical);
            this.handleUnionValueChange(Type.CATEGORICAL, oldValue, this.categorical);
        }

        @Override
        public final Builder categorical(Collection<CategoricalScaleDefinition> categorical) {
            List<CategoricalScaleDefinition> oldValue = this.categorical;
            this.categorical = CategoricalScaleDefinitionsCopier.copy(categorical);
            this.handleUnionValueChange(Type.CATEGORICAL, oldValue, this.categorical);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorical(CategoricalScaleDefinition ... categorical) {
            this.categorical(Arrays.asList(categorical));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorical(Consumer<CategoricalScaleDefinition.Builder> ... categorical) {
            this.categorical(Stream.of(categorical).map(c -> (CategoricalScaleDefinition)((CategoricalScaleDefinition.Builder)CategoricalScaleDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RatingScale build() {
            return new RatingScale(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RatingScale> {
        public Builder numerical(Collection<NumericalScaleDefinition> var1);

        public Builder numerical(NumericalScaleDefinition ... var1);

        public Builder numerical(Consumer<NumericalScaleDefinition.Builder> ... var1);

        public Builder categorical(Collection<CategoricalScaleDefinition> var1);

        public Builder categorical(CategoricalScaleDefinition ... var1);

        public Builder categorical(Consumer<CategoricalScaleDefinition.Builder> ... var1);
    }
}

