/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AllowedQueryParametersCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AllowedRequestHeadersCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AllowedResponseHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataConfiguration> {
    private static final SdkField<List<String>> ALLOWED_REQUEST_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedRequestHeaders").getter(MetadataConfiguration.getter(MetadataConfiguration::allowedRequestHeaders)).setter(MetadataConfiguration.setter(Builder::allowedRequestHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedRequestHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedQueryParameters").getter(MetadataConfiguration.getter(MetadataConfiguration::allowedQueryParameters)).setter(MetadataConfiguration.setter(Builder::allowedQueryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedQueryParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_RESPONSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedResponseHeaders").getter(MetadataConfiguration.getter(MetadataConfiguration::allowedResponseHeaders)).setter(MetadataConfiguration.setter(Builder::allowedResponseHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResponseHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_REQUEST_HEADERS_FIELD, ALLOWED_QUERY_PARAMETERS_FIELD, ALLOWED_RESPONSE_HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowedRequestHeaders;
    private final List<String> allowedQueryParameters;
    private final List<String> allowedResponseHeaders;

    private MetadataConfiguration(BuilderImpl builder) {
        this.allowedRequestHeaders = builder.allowedRequestHeaders;
        this.allowedQueryParameters = builder.allowedQueryParameters;
        this.allowedResponseHeaders = builder.allowedResponseHeaders;
    }

    public final boolean hasAllowedRequestHeaders() {
        return this.allowedRequestHeaders != null && !(this.allowedRequestHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> allowedRequestHeaders() {
        return this.allowedRequestHeaders;
    }

    public final boolean hasAllowedQueryParameters() {
        return this.allowedQueryParameters != null && !(this.allowedQueryParameters instanceof SdkAutoConstructList);
    }

    public final List<String> allowedQueryParameters() {
        return this.allowedQueryParameters;
    }

    public final boolean hasAllowedResponseHeaders() {
        return this.allowedResponseHeaders != null && !(this.allowedResponseHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> allowedResponseHeaders() {
        return this.allowedResponseHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedRequestHeaders() ? this.allowedRequestHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedQueryParameters() ? this.allowedQueryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedResponseHeaders() ? this.allowedResponseHeaders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfiguration)) {
            return false;
        }
        MetadataConfiguration other = (MetadataConfiguration)obj;
        return this.hasAllowedRequestHeaders() == other.hasAllowedRequestHeaders() && Objects.equals(this.allowedRequestHeaders(), other.allowedRequestHeaders()) && this.hasAllowedQueryParameters() == other.hasAllowedQueryParameters() && Objects.equals(this.allowedQueryParameters(), other.allowedQueryParameters()) && this.hasAllowedResponseHeaders() == other.hasAllowedResponseHeaders() && Objects.equals(this.allowedResponseHeaders(), other.allowedResponseHeaders());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataConfiguration").add("AllowedRequestHeaders", this.hasAllowedRequestHeaders() ? this.allowedRequestHeaders() : null).add("AllowedQueryParameters", this.hasAllowedQueryParameters() ? this.allowedQueryParameters() : null).add("AllowedResponseHeaders", this.hasAllowedResponseHeaders() ? this.allowedResponseHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedRequestHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowedRequestHeaders()));
            }
            case "allowedQueryParameters": {
                return Optional.ofNullable(clazz.cast(this.allowedQueryParameters()));
            }
            case "allowedResponseHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowedResponseHeaders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("allowedRequestHeaders", ALLOWED_REQUEST_HEADERS_FIELD);
        map.put("allowedQueryParameters", ALLOWED_QUERY_PARAMETERS_FIELD);
        map.put("allowedResponseHeaders", ALLOWED_RESPONSE_HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfiguration, T> g) {
        return obj -> g.apply((MetadataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedRequestHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedQueryParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedResponseHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfiguration model) {
            this.allowedRequestHeaders(model.allowedRequestHeaders);
            this.allowedQueryParameters(model.allowedQueryParameters);
            this.allowedResponseHeaders(model.allowedResponseHeaders);
        }

        public final Collection<String> getAllowedRequestHeaders() {
            if (this.allowedRequestHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedRequestHeaders;
        }

        public final void setAllowedRequestHeaders(Collection<String> allowedRequestHeaders) {
            this.allowedRequestHeaders = AllowedRequestHeadersCopier.copy(allowedRequestHeaders);
        }

        @Override
        public final Builder allowedRequestHeaders(Collection<String> allowedRequestHeaders) {
            this.allowedRequestHeaders = AllowedRequestHeadersCopier.copy(allowedRequestHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedRequestHeaders(String ... allowedRequestHeaders) {
            this.allowedRequestHeaders(Arrays.asList(allowedRequestHeaders));
            return this;
        }

        public final Collection<String> getAllowedQueryParameters() {
            if (this.allowedQueryParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedQueryParameters;
        }

        public final void setAllowedQueryParameters(Collection<String> allowedQueryParameters) {
            this.allowedQueryParameters = AllowedQueryParametersCopier.copy(allowedQueryParameters);
        }

        @Override
        public final Builder allowedQueryParameters(Collection<String> allowedQueryParameters) {
            this.allowedQueryParameters = AllowedQueryParametersCopier.copy(allowedQueryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedQueryParameters(String ... allowedQueryParameters) {
            this.allowedQueryParameters(Arrays.asList(allowedQueryParameters));
            return this;
        }

        public final Collection<String> getAllowedResponseHeaders() {
            if (this.allowedResponseHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedResponseHeaders;
        }

        public final void setAllowedResponseHeaders(Collection<String> allowedResponseHeaders) {
            this.allowedResponseHeaders = AllowedResponseHeadersCopier.copy(allowedResponseHeaders);
        }

        @Override
        public final Builder allowedResponseHeaders(Collection<String> allowedResponseHeaders) {
            this.allowedResponseHeaders = AllowedResponseHeadersCopier.copy(allowedResponseHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResponseHeaders(String ... allowedResponseHeaders) {
            this.allowedResponseHeaders(Arrays.asList(allowedResponseHeaders));
            return this;
        }

        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataConfiguration> {
        public Builder allowedRequestHeaders(Collection<String> var1);

        public Builder allowedRequestHeaders(String ... var1);

        public Builder allowedQueryParameters(Collection<String> var1);

        public Builder allowedQueryParameters(String ... var1);

        public Builder allowedResponseHeaders(Collection<String> var1);

        public Builder allowedResponseHeaders(String ... var1);
    }
}

