/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategy;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemoryStrategyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Memory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Memory> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Memory.getter(Memory::arn)).setter(Memory.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Memory.getter(Memory::id)).setter(Memory.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Memory.getter(Memory::name)).setter(Memory.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Memory.getter(Memory::description)).setter(Memory.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKeyArn").getter(Memory.getter(Memory::encryptionKeyArn)).setter(Memory.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()}).build();
    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryExecutionRoleArn").getter(Memory.getter(Memory::memoryExecutionRoleArn)).setter(Memory.setter(Builder::memoryExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build()}).build();
    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("eventExpiryDuration").getter(Memory.getter(Memory::eventExpiryDuration)).setter(Memory.setter(Builder::eventExpiryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Memory.getter(Memory::statusAsString)).setter(Memory.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(Memory.getter(Memory::failureReason)).setter(Memory.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Memory.getter(Memory::createdAt)).setter(Memory.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Memory.getter(Memory::updatedAt)).setter(Memory.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<List<MemoryStrategy>> STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("strategies").getter(Memory.getter(Memory::strategies)).setter(Memory.setter(Builder::strategies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemoryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENCRYPTION_KEY_ARN_FIELD, MEMORY_EXECUTION_ROLE_ARN_FIELD, EVENT_EXPIRY_DURATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STRATEGIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Memory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String name;
    private final String description;
    private final String encryptionKeyArn;
    private final String memoryExecutionRoleArn;
    private final Integer eventExpiryDuration;
    private final String status;
    private final String failureReason;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<MemoryStrategy> strategies;

    private Memory(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.strategies = builder.strategies;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String memoryExecutionRoleArn() {
        return this.memoryExecutionRoleArn;
    }

    public final Integer eventExpiryDuration() {
        return this.eventExpiryDuration;
    }

    public final MemoryStatus status() {
        return MemoryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasStrategies() {
        return this.strategies != null && !(this.strategies instanceof SdkAutoConstructList);
    }

    public final List<MemoryStrategy> strategies() {
        return this.strategies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStrategies() ? this.strategies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Memory)) {
            return false;
        }
        Memory other = (Memory)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.memoryExecutionRoleArn(), other.memoryExecutionRoleArn()) && Objects.equals(this.eventExpiryDuration(), other.eventExpiryDuration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasStrategies() == other.hasStrategies() && Objects.equals(this.strategies(), other.strategies());
    }

    public final String toString() {
        return ToString.builder((String)"Memory").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("MemoryExecutionRoleArn", (Object)this.memoryExecutionRoleArn()).add("EventExpiryDuration", (Object)this.eventExpiryDuration()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Strategies", this.hasStrategies() ? this.strategies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "memoryExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.memoryExecutionRoleArn()));
            }
            case "eventExpiryDuration": {
                return Optional.ofNullable(clazz.cast(this.eventExpiryDuration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "strategies": {
                return Optional.ofNullable(clazz.cast(this.strategies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("strategies", STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Memory, T> g) {
        return obj -> g.apply((Memory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String description;
        private String encryptionKeyArn;
        private String memoryExecutionRoleArn;
        private Integer eventExpiryDuration;
        private String status;
        private String failureReason;
        private Instant createdAt;
        private Instant updatedAt;
        private List<MemoryStrategy> strategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Memory model) {
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            this.eventExpiryDuration(model.eventExpiryDuration);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.strategies(model.strategies);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return this.memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return this.eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemoryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<MemoryStrategy.Builder> getStrategies() {
            List<MemoryStrategy.Builder> result = MemoryStrategyListCopier.copyToBuilder(this.strategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStrategies(Collection<MemoryStrategy.BuilderImpl> strategies) {
            this.strategies = MemoryStrategyListCopier.copyFromBuilder(strategies);
        }

        @Override
        public final Builder strategies(Collection<MemoryStrategy> strategies) {
            this.strategies = MemoryStrategyListCopier.copy(strategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strategies(MemoryStrategy ... strategies) {
            this.strategies(Arrays.asList(strategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder strategies(Consumer<MemoryStrategy.Builder> ... strategies) {
            this.strategies(Stream.of(strategies).map(c -> (MemoryStrategy)((MemoryStrategy.Builder)MemoryStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Memory build() {
            return new Memory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Memory> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder memoryExecutionRoleArn(String var1);

        public Builder eventExpiryDuration(Integer var1);

        public Builder status(String var1);

        public Builder status(MemoryStatus var1);

        public Builder failureReason(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder strategies(Collection<MemoryStrategy> var1);

        public Builder strategies(MemoryStrategy ... var1);

        public Builder strategies(Consumer<MemoryStrategy.Builder> ... var1);
    }
}

