/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayInterceptionPoint;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayInterceptionPointsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InterceptorConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.InterceptorInputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayInterceptorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayInterceptorConfiguration> {
    private static final SdkField<InterceptorConfiguration> INTERCEPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("interceptor").getter(GatewayInterceptorConfiguration.getter(GatewayInterceptorConfiguration::interceptor)).setter(GatewayInterceptorConfiguration.setter(Builder::interceptor)).constructor(InterceptorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interceptor").build()}).build();
    private static final SdkField<List<String>> INTERCEPTION_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("interceptionPoints").getter(GatewayInterceptorConfiguration.getter(GatewayInterceptorConfiguration::interceptionPointsAsStrings)).setter(GatewayInterceptorConfiguration.setter(Builder::interceptionPointsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interceptionPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InterceptorInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConfiguration").getter(GatewayInterceptorConfiguration.getter(GatewayInterceptorConfiguration::inputConfiguration)).setter(GatewayInterceptorConfiguration.setter(Builder::inputConfiguration)).constructor(InterceptorInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCEPTOR_FIELD, INTERCEPTION_POINTS_FIELD, INPUT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayInterceptorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InterceptorConfiguration interceptor;
    private final List<String> interceptionPoints;
    private final InterceptorInputConfiguration inputConfiguration;

    private GatewayInterceptorConfiguration(BuilderImpl builder) {
        this.interceptor = builder.interceptor;
        this.interceptionPoints = builder.interceptionPoints;
        this.inputConfiguration = builder.inputConfiguration;
    }

    public final InterceptorConfiguration interceptor() {
        return this.interceptor;
    }

    public final List<GatewayInterceptionPoint> interceptionPoints() {
        return GatewayInterceptionPointsCopier.copyStringToEnum(this.interceptionPoints);
    }

    public final boolean hasInterceptionPoints() {
        return this.interceptionPoints != null && !(this.interceptionPoints instanceof SdkAutoConstructList);
    }

    public final List<String> interceptionPointsAsStrings() {
        return this.interceptionPoints;
    }

    public final InterceptorInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interceptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterceptionPoints() ? this.interceptionPointsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInterceptorConfiguration)) {
            return false;
        }
        GatewayInterceptorConfiguration other = (GatewayInterceptorConfiguration)obj;
        return Objects.equals(this.interceptor(), other.interceptor()) && this.hasInterceptionPoints() == other.hasInterceptionPoints() && Objects.equals(this.interceptionPointsAsStrings(), other.interceptionPointsAsStrings()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayInterceptorConfiguration").add("Interceptor", (Object)this.interceptor()).add("InterceptionPoints", this.hasInterceptionPoints() ? this.interceptionPointsAsStrings() : null).add("InputConfiguration", (Object)this.inputConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interceptor": {
                return Optional.ofNullable(clazz.cast(this.interceptor()));
            }
            case "interceptionPoints": {
                return Optional.ofNullable(clazz.cast(this.interceptionPointsAsStrings()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("interceptor", INTERCEPTOR_FIELD);
        map.put("interceptionPoints", INTERCEPTION_POINTS_FIELD);
        map.put("inputConfiguration", INPUT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayInterceptorConfiguration, T> g) {
        return obj -> g.apply((GatewayInterceptorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InterceptorConfiguration interceptor;
        private List<String> interceptionPoints = DefaultSdkAutoConstructList.getInstance();
        private InterceptorInputConfiguration inputConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInterceptorConfiguration model) {
            this.interceptor(model.interceptor);
            this.interceptionPointsWithStrings(model.interceptionPoints);
            this.inputConfiguration(model.inputConfiguration);
        }

        public final InterceptorConfiguration.Builder getInterceptor() {
            return this.interceptor != null ? this.interceptor.toBuilder() : null;
        }

        public final void setInterceptor(InterceptorConfiguration.BuilderImpl interceptor) {
            this.interceptor = interceptor != null ? interceptor.build() : null;
        }

        @Override
        public final Builder interceptor(InterceptorConfiguration interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        public final Collection<String> getInterceptionPoints() {
            if (this.interceptionPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.interceptionPoints;
        }

        public final void setInterceptionPoints(Collection<String> interceptionPoints) {
            this.interceptionPoints = GatewayInterceptionPointsCopier.copy(interceptionPoints);
        }

        @Override
        public final Builder interceptionPointsWithStrings(Collection<String> interceptionPoints) {
            this.interceptionPoints = GatewayInterceptionPointsCopier.copy(interceptionPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interceptionPointsWithStrings(String ... interceptionPoints) {
            this.interceptionPointsWithStrings(Arrays.asList(interceptionPoints));
            return this;
        }

        @Override
        public final Builder interceptionPoints(Collection<GatewayInterceptionPoint> interceptionPoints) {
            this.interceptionPoints = GatewayInterceptionPointsCopier.copyEnumToString(interceptionPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interceptionPoints(GatewayInterceptionPoint ... interceptionPoints) {
            this.interceptionPoints(Arrays.asList(interceptionPoints));
            return this;
        }

        public final InterceptorInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        public final void setInputConfiguration(InterceptorInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        @Override
        public final Builder inputConfiguration(InterceptorInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public GatewayInterceptorConfiguration build() {
            return new GatewayInterceptorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayInterceptorConfiguration> {
        public Builder interceptor(InterceptorConfiguration var1);

        default public Builder interceptor(Consumer<InterceptorConfiguration.Builder> interceptor) {
            return this.interceptor((InterceptorConfiguration)((InterceptorConfiguration.Builder)InterceptorConfiguration.builder().applyMutation(interceptor)).build());
        }

        public Builder interceptionPointsWithStrings(Collection<String> var1);

        public Builder interceptionPointsWithStrings(String ... var1);

        public Builder interceptionPoints(Collection<GatewayInterceptionPoint> var1);

        public Builder interceptionPoints(GatewayInterceptionPoint ... var1);

        public Builder inputConfiguration(InterceptorInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<InterceptorInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((InterceptorInputConfiguration)((InterceptorInputConfiguration.Builder)InterceptorInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }
    }
}

