/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyDefinition;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyValidationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreatePolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreatePolicyRequest.getter(CreatePolicyRequest::name)).setter(CreatePolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PolicyDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(CreatePolicyRequest.getter(CreatePolicyRequest::definition)).setter(CreatePolicyRequest.setter(Builder::definition)).constructor(PolicyDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePolicyRequest.getter(CreatePolicyRequest::description)).setter(CreatePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> VALIDATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationMode").getter(CreatePolicyRequest.getter(CreatePolicyRequest::validationModeAsString)).setter(CreatePolicyRequest.setter(Builder::validationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMode").build()}).build();
    private static final SdkField<String> POLICY_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyEngineId").getter(CreatePolicyRequest.getter(CreatePolicyRequest::policyEngineId)).setter(CreatePolicyRequest.setter(Builder::policyEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyEngineId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePolicyRequest.getter(CreatePolicyRequest::clientToken)).setter(CreatePolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, VALIDATION_MODE_FIELD, POLICY_ENGINE_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePolicyRequest.memberNameToFieldInitializer();
    private final String name;
    private final PolicyDefinition definition;
    private final String description;
    private final String validationMode;
    private final String policyEngineId;
    private final String clientToken;

    private CreatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.definition = builder.definition;
        this.description = builder.description;
        this.validationMode = builder.validationMode;
        this.policyEngineId = builder.policyEngineId;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final PolicyDefinition definition() {
        return this.definition;
    }

    public final String description() {
        return this.description;
    }

    public final PolicyValidationMode validationMode() {
        return PolicyValidationMode.fromValue(this.validationMode);
    }

    public final String validationModeAsString() {
        return this.validationMode;
    }

    public final String policyEngineId() {
        return this.policyEngineId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEngineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.validationModeAsString(), other.validationModeAsString()) && Objects.equals(this.policyEngineId(), other.policyEngineId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyRequest").add("Name", (Object)this.name()).add("Definition", (Object)this.definition()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ValidationMode", (Object)this.validationModeAsString()).add("PolicyEngineId", (Object)this.policyEngineId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "validationMode": {
                return Optional.ofNullable(clazz.cast(this.validationModeAsString()));
            }
            case "policyEngineId": {
                return Optional.ofNullable(clazz.cast(this.policyEngineId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("validationMode", VALIDATION_MODE_FIELD);
        map.put("policyEngineId", POLICY_ENGINE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyRequest, T> g) {
        return obj -> g.apply((CreatePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String name;
        private PolicyDefinition definition;
        private String description;
        private String validationMode;
        private String policyEngineId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyRequest model) {
            super(model);
            this.name(model.name);
            this.definition(model.definition);
            this.description(model.description);
            this.validationMode(model.validationMode);
            this.policyEngineId(model.policyEngineId);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PolicyDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getValidationMode() {
            return this.validationMode;
        }

        public final void setValidationMode(String validationMode) {
            this.validationMode = validationMode;
        }

        @Override
        public final Builder validationMode(String validationMode) {
            this.validationMode = validationMode;
            return this;
        }

        @Override
        public final Builder validationMode(PolicyValidationMode validationMode) {
            this.validationMode(validationMode == null ? null : validationMode.toString());
            return this;
        }

        public final String getPolicyEngineId() {
            return this.policyEngineId;
        }

        public final void setPolicyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
        }

        @Override
        public final Builder policyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyRequest> {
        public Builder name(String var1);

        public Builder definition(PolicyDefinition var1);

        default public Builder definition(Consumer<PolicyDefinition.Builder> definition) {
            return this.definition((PolicyDefinition)((PolicyDefinition.Builder)PolicyDefinition.builder().applyMutation(definition)).build());
        }

        public Builder description(String var1);

        public Builder validationMode(String var1);

        public Builder validationMode(PolicyValidationMode var1);

        public Builder policyEngineId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

