/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyEnginesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyEnginesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyEngine;

public class ListPolicyEnginesIterable
implements SdkIterable<ListPolicyEnginesResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListPolicyEnginesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyEnginesIterable(BedrockAgentCoreControlClient client, ListPolicyEnginesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyEnginesResponseFetcher();
    }

    public Iterator<ListPolicyEnginesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyEngine> policyEngines() {
        Function<ListPolicyEnginesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyEngines() != null) {
                return response.policyEngines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyEnginesResponseFetcher
    implements SyncPageFetcher<ListPolicyEnginesResponse> {
        private ListPolicyEnginesResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyEnginesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyEnginesResponse nextPage(ListPolicyEnginesResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyEnginesIterable.this.client.listPolicyEngines(ListPolicyEnginesIterable.this.firstRequest);
            }
            return ListPolicyEnginesIterable.this.client.listPolicyEngines((ListPolicyEnginesRequest)((Object)ListPolicyEnginesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

