/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CustomReflectionConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EpisodicReflectionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReflectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReflectionConfiguration> {
    private static final SdkField<CustomReflectionConfiguration> CUSTOM_REFLECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customReflectionConfiguration").getter(ReflectionConfiguration.getter(ReflectionConfiguration::customReflectionConfiguration)).setter(ReflectionConfiguration.setter(Builder::customReflectionConfiguration)).constructor(CustomReflectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customReflectionConfiguration").build()}).build();
    private static final SdkField<EpisodicReflectionConfiguration> EPISODIC_REFLECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("episodicReflectionConfiguration").getter(ReflectionConfiguration.getter(ReflectionConfiguration::episodicReflectionConfiguration)).setter(ReflectionConfiguration.setter(Builder::episodicReflectionConfiguration)).constructor(EpisodicReflectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("episodicReflectionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_REFLECTION_CONFIGURATION_FIELD, EPISODIC_REFLECTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReflectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomReflectionConfiguration customReflectionConfiguration;
    private final EpisodicReflectionConfiguration episodicReflectionConfiguration;
    private final Type type;

    private ReflectionConfiguration(BuilderImpl builder) {
        this.customReflectionConfiguration = builder.customReflectionConfiguration;
        this.episodicReflectionConfiguration = builder.episodicReflectionConfiguration;
        this.type = builder.type;
    }

    public final CustomReflectionConfiguration customReflectionConfiguration() {
        return this.customReflectionConfiguration;
    }

    public final EpisodicReflectionConfiguration episodicReflectionConfiguration() {
        return this.episodicReflectionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customReflectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.episodicReflectionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReflectionConfiguration)) {
            return false;
        }
        ReflectionConfiguration other = (ReflectionConfiguration)obj;
        return Objects.equals(this.customReflectionConfiguration(), other.customReflectionConfiguration()) && Objects.equals(this.episodicReflectionConfiguration(), other.episodicReflectionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ReflectionConfiguration").add("CustomReflectionConfiguration", (Object)this.customReflectionConfiguration()).add("EpisodicReflectionConfiguration", (Object)this.episodicReflectionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customReflectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customReflectionConfiguration()));
            }
            case "episodicReflectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.episodicReflectionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static ReflectionConfiguration fromCustomReflectionConfiguration(CustomReflectionConfiguration customReflectionConfiguration) {
        return (ReflectionConfiguration)ReflectionConfiguration.builder().customReflectionConfiguration(customReflectionConfiguration).build();
    }

    public static ReflectionConfiguration fromCustomReflectionConfiguration(Consumer<CustomReflectionConfiguration.Builder> customReflectionConfiguration) {
        CustomReflectionConfiguration.Builder builder = CustomReflectionConfiguration.builder();
        customReflectionConfiguration.accept(builder);
        return ReflectionConfiguration.fromCustomReflectionConfiguration((CustomReflectionConfiguration)builder.build());
    }

    public static ReflectionConfiguration fromEpisodicReflectionConfiguration(EpisodicReflectionConfiguration episodicReflectionConfiguration) {
        return (ReflectionConfiguration)ReflectionConfiguration.builder().episodicReflectionConfiguration(episodicReflectionConfiguration).build();
    }

    public static ReflectionConfiguration fromEpisodicReflectionConfiguration(Consumer<EpisodicReflectionConfiguration.Builder> episodicReflectionConfiguration) {
        EpisodicReflectionConfiguration.Builder builder = EpisodicReflectionConfiguration.builder();
        episodicReflectionConfiguration.accept(builder);
        return ReflectionConfiguration.fromEpisodicReflectionConfiguration((EpisodicReflectionConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customReflectionConfiguration", CUSTOM_REFLECTION_CONFIGURATION_FIELD);
        map.put("episodicReflectionConfiguration", EPISODIC_REFLECTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReflectionConfiguration, T> g) {
        return obj -> g.apply((ReflectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CUSTOM_REFLECTION_CONFIGURATION,
        EPISODIC_REFLECTION_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CustomReflectionConfiguration customReflectionConfiguration;
        private EpisodicReflectionConfiguration episodicReflectionConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReflectionConfiguration model) {
            this.customReflectionConfiguration(model.customReflectionConfiguration);
            this.episodicReflectionConfiguration(model.episodicReflectionConfiguration);
        }

        public final CustomReflectionConfiguration.Builder getCustomReflectionConfiguration() {
            return this.customReflectionConfiguration != null ? this.customReflectionConfiguration.toBuilder() : null;
        }

        public final void setCustomReflectionConfiguration(CustomReflectionConfiguration.BuilderImpl customReflectionConfiguration) {
            CustomReflectionConfiguration oldValue = this.customReflectionConfiguration;
            this.customReflectionConfiguration = customReflectionConfiguration != null ? customReflectionConfiguration.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_REFLECTION_CONFIGURATION, oldValue, this.customReflectionConfiguration);
        }

        @Override
        public final Builder customReflectionConfiguration(CustomReflectionConfiguration customReflectionConfiguration) {
            CustomReflectionConfiguration oldValue = this.customReflectionConfiguration;
            this.customReflectionConfiguration = customReflectionConfiguration;
            this.handleUnionValueChange(Type.CUSTOM_REFLECTION_CONFIGURATION, oldValue, this.customReflectionConfiguration);
            return this;
        }

        public final EpisodicReflectionConfiguration.Builder getEpisodicReflectionConfiguration() {
            return this.episodicReflectionConfiguration != null ? this.episodicReflectionConfiguration.toBuilder() : null;
        }

        public final void setEpisodicReflectionConfiguration(EpisodicReflectionConfiguration.BuilderImpl episodicReflectionConfiguration) {
            EpisodicReflectionConfiguration oldValue = this.episodicReflectionConfiguration;
            this.episodicReflectionConfiguration = episodicReflectionConfiguration != null ? episodicReflectionConfiguration.build() : null;
            this.handleUnionValueChange(Type.EPISODIC_REFLECTION_CONFIGURATION, oldValue, this.episodicReflectionConfiguration);
        }

        @Override
        public final Builder episodicReflectionConfiguration(EpisodicReflectionConfiguration episodicReflectionConfiguration) {
            EpisodicReflectionConfiguration oldValue = this.episodicReflectionConfiguration;
            this.episodicReflectionConfiguration = episodicReflectionConfiguration;
            this.handleUnionValueChange(Type.EPISODIC_REFLECTION_CONFIGURATION, oldValue, this.episodicReflectionConfiguration);
            return this;
        }

        public ReflectionConfiguration build() {
            return new ReflectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReflectionConfiguration> {
        public Builder customReflectionConfiguration(CustomReflectionConfiguration var1);

        default public Builder customReflectionConfiguration(Consumer<CustomReflectionConfiguration.Builder> customReflectionConfiguration) {
            return this.customReflectionConfiguration((CustomReflectionConfiguration)((CustomReflectionConfiguration.Builder)CustomReflectionConfiguration.builder().applyMutation(customReflectionConfiguration)).build());
        }

        public Builder episodicReflectionConfiguration(EpisodicReflectionConfiguration var1);

        default public Builder episodicReflectionConfiguration(Consumer<EpisodicReflectionConfiguration.Builder> episodicReflectionConfiguration) {
            return this.episodicReflectionConfiguration((EpisodicReflectionConfiguration)((EpisodicReflectionConfiguration.Builder)EpisodicReflectionConfiguration.builder().applyMutation(episodicReflectionConfiguration)).build());
        }
    }
}

