/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CustomMemoryStrategyInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EpisodicMemoryStrategyInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SemanticMemoryStrategyInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SummaryMemoryStrategyInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UserPreferenceMemoryStrategyInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemoryStrategyInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemoryStrategyInput> {
    private static final SdkField<SemanticMemoryStrategyInput> SEMANTIC_MEMORY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("semanticMemoryStrategy").getter(MemoryStrategyInput.getter(MemoryStrategyInput::semanticMemoryStrategy)).setter(MemoryStrategyInput.setter(Builder::semanticMemoryStrategy)).constructor(SemanticMemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticMemoryStrategy").build()}).build();
    private static final SdkField<SummaryMemoryStrategyInput> SUMMARY_MEMORY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summaryMemoryStrategy").getter(MemoryStrategyInput.getter(MemoryStrategyInput::summaryMemoryStrategy)).setter(MemoryStrategyInput.setter(Builder::summaryMemoryStrategy)).constructor(SummaryMemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryMemoryStrategy").build()}).build();
    private static final SdkField<UserPreferenceMemoryStrategyInput> USER_PREFERENCE_MEMORY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPreferenceMemoryStrategy").getter(MemoryStrategyInput.getter(MemoryStrategyInput::userPreferenceMemoryStrategy)).setter(MemoryStrategyInput.setter(Builder::userPreferenceMemoryStrategy)).constructor(UserPreferenceMemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceMemoryStrategy").build()}).build();
    private static final SdkField<CustomMemoryStrategyInput> CUSTOM_MEMORY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customMemoryStrategy").getter(MemoryStrategyInput.getter(MemoryStrategyInput::customMemoryStrategy)).setter(MemoryStrategyInput.setter(Builder::customMemoryStrategy)).constructor(CustomMemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMemoryStrategy").build()}).build();
    private static final SdkField<EpisodicMemoryStrategyInput> EPISODIC_MEMORY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("episodicMemoryStrategy").getter(MemoryStrategyInput.getter(MemoryStrategyInput::episodicMemoryStrategy)).setter(MemoryStrategyInput.setter(Builder::episodicMemoryStrategy)).constructor(EpisodicMemoryStrategyInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("episodicMemoryStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_MEMORY_STRATEGY_FIELD, SUMMARY_MEMORY_STRATEGY_FIELD, USER_PREFERENCE_MEMORY_STRATEGY_FIELD, CUSTOM_MEMORY_STRATEGY_FIELD, EPISODIC_MEMORY_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemoryStrategyInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SemanticMemoryStrategyInput semanticMemoryStrategy;
    private final SummaryMemoryStrategyInput summaryMemoryStrategy;
    private final UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy;
    private final CustomMemoryStrategyInput customMemoryStrategy;
    private final EpisodicMemoryStrategyInput episodicMemoryStrategy;
    private final Type type;

    private MemoryStrategyInput(BuilderImpl builder) {
        this.semanticMemoryStrategy = builder.semanticMemoryStrategy;
        this.summaryMemoryStrategy = builder.summaryMemoryStrategy;
        this.userPreferenceMemoryStrategy = builder.userPreferenceMemoryStrategy;
        this.customMemoryStrategy = builder.customMemoryStrategy;
        this.episodicMemoryStrategy = builder.episodicMemoryStrategy;
        this.type = builder.type;
    }

    public final SemanticMemoryStrategyInput semanticMemoryStrategy() {
        return this.semanticMemoryStrategy;
    }

    public final SummaryMemoryStrategyInput summaryMemoryStrategy() {
        return this.summaryMemoryStrategy;
    }

    public final UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy() {
        return this.userPreferenceMemoryStrategy;
    }

    public final CustomMemoryStrategyInput customMemoryStrategy() {
        return this.customMemoryStrategy;
    }

    public final EpisodicMemoryStrategyInput episodicMemoryStrategy() {
        return this.episodicMemoryStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPreferenceMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.customMemoryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.episodicMemoryStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryStrategyInput)) {
            return false;
        }
        MemoryStrategyInput other = (MemoryStrategyInput)obj;
        return Objects.equals(this.semanticMemoryStrategy(), other.semanticMemoryStrategy()) && Objects.equals(this.summaryMemoryStrategy(), other.summaryMemoryStrategy()) && Objects.equals(this.userPreferenceMemoryStrategy(), other.userPreferenceMemoryStrategy()) && Objects.equals(this.customMemoryStrategy(), other.customMemoryStrategy()) && Objects.equals(this.episodicMemoryStrategy(), other.episodicMemoryStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"MemoryStrategyInput").add("SemanticMemoryStrategy", (Object)this.semanticMemoryStrategy()).add("SummaryMemoryStrategy", (Object)this.summaryMemoryStrategy()).add("UserPreferenceMemoryStrategy", (Object)this.userPreferenceMemoryStrategy()).add("CustomMemoryStrategy", (Object)this.customMemoryStrategy()).add("EpisodicMemoryStrategy", (Object)this.episodicMemoryStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "semanticMemoryStrategy": {
                return Optional.ofNullable(clazz.cast(this.semanticMemoryStrategy()));
            }
            case "summaryMemoryStrategy": {
                return Optional.ofNullable(clazz.cast(this.summaryMemoryStrategy()));
            }
            case "userPreferenceMemoryStrategy": {
                return Optional.ofNullable(clazz.cast(this.userPreferenceMemoryStrategy()));
            }
            case "customMemoryStrategy": {
                return Optional.ofNullable(clazz.cast(this.customMemoryStrategy()));
            }
            case "episodicMemoryStrategy": {
                return Optional.ofNullable(clazz.cast(this.episodicMemoryStrategy()));
            }
        }
        return Optional.empty();
    }

    public static MemoryStrategyInput fromSemanticMemoryStrategy(SemanticMemoryStrategyInput semanticMemoryStrategy) {
        return (MemoryStrategyInput)MemoryStrategyInput.builder().semanticMemoryStrategy(semanticMemoryStrategy).build();
    }

    public static MemoryStrategyInput fromSemanticMemoryStrategy(Consumer<SemanticMemoryStrategyInput.Builder> semanticMemoryStrategy) {
        SemanticMemoryStrategyInput.Builder builder = SemanticMemoryStrategyInput.builder();
        semanticMemoryStrategy.accept(builder);
        return MemoryStrategyInput.fromSemanticMemoryStrategy((SemanticMemoryStrategyInput)builder.build());
    }

    public static MemoryStrategyInput fromSummaryMemoryStrategy(SummaryMemoryStrategyInput summaryMemoryStrategy) {
        return (MemoryStrategyInput)MemoryStrategyInput.builder().summaryMemoryStrategy(summaryMemoryStrategy).build();
    }

    public static MemoryStrategyInput fromSummaryMemoryStrategy(Consumer<SummaryMemoryStrategyInput.Builder> summaryMemoryStrategy) {
        SummaryMemoryStrategyInput.Builder builder = SummaryMemoryStrategyInput.builder();
        summaryMemoryStrategy.accept(builder);
        return MemoryStrategyInput.fromSummaryMemoryStrategy((SummaryMemoryStrategyInput)builder.build());
    }

    public static MemoryStrategyInput fromUserPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy) {
        return (MemoryStrategyInput)MemoryStrategyInput.builder().userPreferenceMemoryStrategy(userPreferenceMemoryStrategy).build();
    }

    public static MemoryStrategyInput fromUserPreferenceMemoryStrategy(Consumer<UserPreferenceMemoryStrategyInput.Builder> userPreferenceMemoryStrategy) {
        UserPreferenceMemoryStrategyInput.Builder builder = UserPreferenceMemoryStrategyInput.builder();
        userPreferenceMemoryStrategy.accept(builder);
        return MemoryStrategyInput.fromUserPreferenceMemoryStrategy((UserPreferenceMemoryStrategyInput)builder.build());
    }

    public static MemoryStrategyInput fromCustomMemoryStrategy(CustomMemoryStrategyInput customMemoryStrategy) {
        return (MemoryStrategyInput)MemoryStrategyInput.builder().customMemoryStrategy(customMemoryStrategy).build();
    }

    public static MemoryStrategyInput fromCustomMemoryStrategy(Consumer<CustomMemoryStrategyInput.Builder> customMemoryStrategy) {
        CustomMemoryStrategyInput.Builder builder = CustomMemoryStrategyInput.builder();
        customMemoryStrategy.accept(builder);
        return MemoryStrategyInput.fromCustomMemoryStrategy((CustomMemoryStrategyInput)builder.build());
    }

    public static MemoryStrategyInput fromEpisodicMemoryStrategy(EpisodicMemoryStrategyInput episodicMemoryStrategy) {
        return (MemoryStrategyInput)MemoryStrategyInput.builder().episodicMemoryStrategy(episodicMemoryStrategy).build();
    }

    public static MemoryStrategyInput fromEpisodicMemoryStrategy(Consumer<EpisodicMemoryStrategyInput.Builder> episodicMemoryStrategy) {
        EpisodicMemoryStrategyInput.Builder builder = EpisodicMemoryStrategyInput.builder();
        episodicMemoryStrategy.accept(builder);
        return MemoryStrategyInput.fromEpisodicMemoryStrategy((EpisodicMemoryStrategyInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semanticMemoryStrategy", SEMANTIC_MEMORY_STRATEGY_FIELD);
        map.put("summaryMemoryStrategy", SUMMARY_MEMORY_STRATEGY_FIELD);
        map.put("userPreferenceMemoryStrategy", USER_PREFERENCE_MEMORY_STRATEGY_FIELD);
        map.put("customMemoryStrategy", CUSTOM_MEMORY_STRATEGY_FIELD);
        map.put("episodicMemoryStrategy", EPISODIC_MEMORY_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryStrategyInput, T> g) {
        return obj -> g.apply((MemoryStrategyInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SEMANTIC_MEMORY_STRATEGY,
        SUMMARY_MEMORY_STRATEGY,
        USER_PREFERENCE_MEMORY_STRATEGY,
        CUSTOM_MEMORY_STRATEGY,
        EPISODIC_MEMORY_STRATEGY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SemanticMemoryStrategyInput semanticMemoryStrategy;
        private SummaryMemoryStrategyInput summaryMemoryStrategy;
        private UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy;
        private CustomMemoryStrategyInput customMemoryStrategy;
        private EpisodicMemoryStrategyInput episodicMemoryStrategy;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryStrategyInput model) {
            this.semanticMemoryStrategy(model.semanticMemoryStrategy);
            this.summaryMemoryStrategy(model.summaryMemoryStrategy);
            this.userPreferenceMemoryStrategy(model.userPreferenceMemoryStrategy);
            this.customMemoryStrategy(model.customMemoryStrategy);
            this.episodicMemoryStrategy(model.episodicMemoryStrategy);
        }

        public final SemanticMemoryStrategyInput.Builder getSemanticMemoryStrategy() {
            return this.semanticMemoryStrategy != null ? this.semanticMemoryStrategy.toBuilder() : null;
        }

        public final void setSemanticMemoryStrategy(SemanticMemoryStrategyInput.BuilderImpl semanticMemoryStrategy) {
            SemanticMemoryStrategyInput oldValue = this.semanticMemoryStrategy;
            this.semanticMemoryStrategy = semanticMemoryStrategy != null ? semanticMemoryStrategy.build() : null;
            this.handleUnionValueChange(Type.SEMANTIC_MEMORY_STRATEGY, oldValue, this.semanticMemoryStrategy);
        }

        @Override
        public final Builder semanticMemoryStrategy(SemanticMemoryStrategyInput semanticMemoryStrategy) {
            SemanticMemoryStrategyInput oldValue = this.semanticMemoryStrategy;
            this.semanticMemoryStrategy = semanticMemoryStrategy;
            this.handleUnionValueChange(Type.SEMANTIC_MEMORY_STRATEGY, oldValue, this.semanticMemoryStrategy);
            return this;
        }

        public final SummaryMemoryStrategyInput.Builder getSummaryMemoryStrategy() {
            return this.summaryMemoryStrategy != null ? this.summaryMemoryStrategy.toBuilder() : null;
        }

        public final void setSummaryMemoryStrategy(SummaryMemoryStrategyInput.BuilderImpl summaryMemoryStrategy) {
            SummaryMemoryStrategyInput oldValue = this.summaryMemoryStrategy;
            this.summaryMemoryStrategy = summaryMemoryStrategy != null ? summaryMemoryStrategy.build() : null;
            this.handleUnionValueChange(Type.SUMMARY_MEMORY_STRATEGY, oldValue, this.summaryMemoryStrategy);
        }

        @Override
        public final Builder summaryMemoryStrategy(SummaryMemoryStrategyInput summaryMemoryStrategy) {
            SummaryMemoryStrategyInput oldValue = this.summaryMemoryStrategy;
            this.summaryMemoryStrategy = summaryMemoryStrategy;
            this.handleUnionValueChange(Type.SUMMARY_MEMORY_STRATEGY, oldValue, this.summaryMemoryStrategy);
            return this;
        }

        public final UserPreferenceMemoryStrategyInput.Builder getUserPreferenceMemoryStrategy() {
            return this.userPreferenceMemoryStrategy != null ? this.userPreferenceMemoryStrategy.toBuilder() : null;
        }

        public final void setUserPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput.BuilderImpl userPreferenceMemoryStrategy) {
            UserPreferenceMemoryStrategyInput oldValue = this.userPreferenceMemoryStrategy;
            this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy != null ? userPreferenceMemoryStrategy.build() : null;
            this.handleUnionValueChange(Type.USER_PREFERENCE_MEMORY_STRATEGY, oldValue, this.userPreferenceMemoryStrategy);
        }

        @Override
        public final Builder userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput userPreferenceMemoryStrategy) {
            UserPreferenceMemoryStrategyInput oldValue = this.userPreferenceMemoryStrategy;
            this.userPreferenceMemoryStrategy = userPreferenceMemoryStrategy;
            this.handleUnionValueChange(Type.USER_PREFERENCE_MEMORY_STRATEGY, oldValue, this.userPreferenceMemoryStrategy);
            return this;
        }

        public final CustomMemoryStrategyInput.Builder getCustomMemoryStrategy() {
            return this.customMemoryStrategy != null ? this.customMemoryStrategy.toBuilder() : null;
        }

        public final void setCustomMemoryStrategy(CustomMemoryStrategyInput.BuilderImpl customMemoryStrategy) {
            CustomMemoryStrategyInput oldValue = this.customMemoryStrategy;
            this.customMemoryStrategy = customMemoryStrategy != null ? customMemoryStrategy.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_MEMORY_STRATEGY, oldValue, this.customMemoryStrategy);
        }

        @Override
        public final Builder customMemoryStrategy(CustomMemoryStrategyInput customMemoryStrategy) {
            CustomMemoryStrategyInput oldValue = this.customMemoryStrategy;
            this.customMemoryStrategy = customMemoryStrategy;
            this.handleUnionValueChange(Type.CUSTOM_MEMORY_STRATEGY, oldValue, this.customMemoryStrategy);
            return this;
        }

        public final EpisodicMemoryStrategyInput.Builder getEpisodicMemoryStrategy() {
            return this.episodicMemoryStrategy != null ? this.episodicMemoryStrategy.toBuilder() : null;
        }

        public final void setEpisodicMemoryStrategy(EpisodicMemoryStrategyInput.BuilderImpl episodicMemoryStrategy) {
            EpisodicMemoryStrategyInput oldValue = this.episodicMemoryStrategy;
            this.episodicMemoryStrategy = episodicMemoryStrategy != null ? episodicMemoryStrategy.build() : null;
            this.handleUnionValueChange(Type.EPISODIC_MEMORY_STRATEGY, oldValue, this.episodicMemoryStrategy);
        }

        @Override
        public final Builder episodicMemoryStrategy(EpisodicMemoryStrategyInput episodicMemoryStrategy) {
            EpisodicMemoryStrategyInput oldValue = this.episodicMemoryStrategy;
            this.episodicMemoryStrategy = episodicMemoryStrategy;
            this.handleUnionValueChange(Type.EPISODIC_MEMORY_STRATEGY, oldValue, this.episodicMemoryStrategy);
            return this;
        }

        public MemoryStrategyInput build() {
            return new MemoryStrategyInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemoryStrategyInput> {
        public Builder semanticMemoryStrategy(SemanticMemoryStrategyInput var1);

        default public Builder semanticMemoryStrategy(Consumer<SemanticMemoryStrategyInput.Builder> semanticMemoryStrategy) {
            return this.semanticMemoryStrategy((SemanticMemoryStrategyInput)((SemanticMemoryStrategyInput.Builder)SemanticMemoryStrategyInput.builder().applyMutation(semanticMemoryStrategy)).build());
        }

        public Builder summaryMemoryStrategy(SummaryMemoryStrategyInput var1);

        default public Builder summaryMemoryStrategy(Consumer<SummaryMemoryStrategyInput.Builder> summaryMemoryStrategy) {
            return this.summaryMemoryStrategy((SummaryMemoryStrategyInput)((SummaryMemoryStrategyInput.Builder)SummaryMemoryStrategyInput.builder().applyMutation(summaryMemoryStrategy)).build());
        }

        public Builder userPreferenceMemoryStrategy(UserPreferenceMemoryStrategyInput var1);

        default public Builder userPreferenceMemoryStrategy(Consumer<UserPreferenceMemoryStrategyInput.Builder> userPreferenceMemoryStrategy) {
            return this.userPreferenceMemoryStrategy((UserPreferenceMemoryStrategyInput)((UserPreferenceMemoryStrategyInput.Builder)UserPreferenceMemoryStrategyInput.builder().applyMutation(userPreferenceMemoryStrategy)).build());
        }

        public Builder customMemoryStrategy(CustomMemoryStrategyInput var1);

        default public Builder customMemoryStrategy(Consumer<CustomMemoryStrategyInput.Builder> customMemoryStrategy) {
            return this.customMemoryStrategy((CustomMemoryStrategyInput)((CustomMemoryStrategyInput.Builder)CustomMemoryStrategyInput.builder().applyMutation(customMemoryStrategy)).build());
        }

        public Builder episodicMemoryStrategy(EpisodicMemoryStrategyInput var1);

        default public Builder episodicMemoryStrategy(Consumer<EpisodicMemoryStrategyInput.Builder> episodicMemoryStrategy) {
            return this.episodicMemoryStrategy((EpisodicMemoryStrategyInput)((EpisodicMemoryStrategyInput.Builder)EpisodicMemoryStrategyInput.builder().applyMutation(episodicMemoryStrategy)).build());
        }
    }
}

