/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummariesCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBrowsersResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListBrowsersResponse> {
    private static final SdkField<List<BrowserSummary>> BROWSER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("browserSummaries").getter(ListBrowsersResponse.getter(ListBrowsersResponse::browserSummaries)).setter(ListBrowsersResponse.setter(Builder::browserSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrowserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBrowsersResponse.getter(ListBrowsersResponse::nextToken)).setter(ListBrowsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBrowsersResponse.memberNameToFieldInitializer();
    private final List<BrowserSummary> browserSummaries;
    private final String nextToken;

    private ListBrowsersResponse(BuilderImpl builder) {
        super(builder);
        this.browserSummaries = builder.browserSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBrowserSummaries() {
        return this.browserSummaries != null && !(this.browserSummaries instanceof SdkAutoConstructList);
    }

    public final List<BrowserSummary> browserSummaries() {
        return this.browserSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrowserSummaries() ? this.browserSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBrowsersResponse)) {
            return false;
        }
        ListBrowsersResponse other = (ListBrowsersResponse)((Object)obj);
        return this.hasBrowserSummaries() == other.hasBrowserSummaries() && Objects.equals(this.browserSummaries(), other.browserSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBrowsersResponse").add("BrowserSummaries", this.hasBrowserSummaries() ? this.browserSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserSummaries": {
                return Optional.ofNullable(clazz.cast(this.browserSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserSummaries", BROWSER_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBrowsersResponse, T> g) {
        return obj -> g.apply((ListBrowsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<BrowserSummary> browserSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBrowsersResponse model) {
            super(model);
            this.browserSummaries(model.browserSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<BrowserSummary.Builder> getBrowserSummaries() {
            List<BrowserSummary.Builder> result = BrowserSummariesCopier.copyToBuilder(this.browserSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrowserSummaries(Collection<BrowserSummary.BuilderImpl> browserSummaries) {
            this.browserSummaries = BrowserSummariesCopier.copyFromBuilder(browserSummaries);
        }

        @Override
        public final Builder browserSummaries(Collection<BrowserSummary> browserSummaries) {
            this.browserSummaries = BrowserSummariesCopier.copy(browserSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSummaries(BrowserSummary ... browserSummaries) {
            this.browserSummaries(Arrays.asList(browserSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder browserSummaries(Consumer<BrowserSummary.Builder> ... browserSummaries) {
            this.browserSummaries(Stream.of(browserSummaries).map(c -> (BrowserSummary)((BrowserSummary.Builder)BrowserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBrowsersResponse build() {
            return new ListBrowsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBrowsersResponse> {
        public Builder browserSummaries(Collection<BrowserSummary> var1);

        public Builder browserSummaries(BrowserSummary ... var1);

        public Builder browserSummaries(Consumer<BrowserSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

