/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentManagedRuntimeType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Code;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeConfigurationEntryPointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeConfiguration> {
    private static final SdkField<Code> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("code").getter(CodeConfiguration.getter(CodeConfiguration::code)).setter(CodeConfiguration.setter(Builder::code)).constructor(Code::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtime").getter(CodeConfiguration.getter(CodeConfiguration::runtimeAsString)).setter(CodeConfiguration.setter(Builder::runtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entryPoint").getter(CodeConfiguration.getter(CodeConfiguration::entryPoint)).setter(CodeConfiguration.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, RUNTIME_FIELD, ENTRY_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Code code;
    private final String runtime;
    private final List<String> entryPoint;

    private CodeConfiguration(BuilderImpl builder) {
        this.code = builder.code;
        this.runtime = builder.runtime;
        this.entryPoint = builder.entryPoint;
    }

    public final Code code() {
        return this.code;
    }

    public final AgentManagedRuntimeType runtime() {
        return AgentManagedRuntimeType.fromValue(this.runtime);
    }

    public final String runtimeAsString() {
        return this.runtime;
    }

    public final boolean hasEntryPoint() {
        return this.entryPoint != null && !(this.entryPoint instanceof SdkAutoConstructList);
    }

    public final List<String> entryPoint() {
        return this.entryPoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryPoint() ? this.entryPoint() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfiguration)) {
            return false;
        }
        CodeConfiguration other = (CodeConfiguration)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.runtimeAsString(), other.runtimeAsString()) && this.hasEntryPoint() == other.hasEntryPoint() && Objects.equals(this.entryPoint(), other.entryPoint());
    }

    public final String toString() {
        return ToString.builder((String)"CodeConfiguration").add("Code", (Object)this.code()).add("Runtime", (Object)this.runtimeAsString()).add("EntryPoint", this.hasEntryPoint() ? this.entryPoint() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtimeAsString()));
            }
            case "entryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", CODE_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("entryPoint", ENTRY_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeConfiguration, T> g) {
        return obj -> g.apply((CodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Code code;
        private String runtime;
        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeConfiguration model) {
            this.code(model.code);
            this.runtime(model.runtime);
            this.entryPoint(model.entryPoint);
        }

        public final Code.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(Code.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(Code code) {
            this.code = code;
            return this;
        }

        public final String getRuntime() {
            return this.runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(AgentManagedRuntimeType runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final Collection<String> getEntryPoint() {
            if (this.entryPoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryPoint;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = CodeConfigurationEntryPointListCopier.copy(entryPoint);
        }

        @Override
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = CodeConfigurationEntryPointListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPoint(String ... entryPoint) {
            this.entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public CodeConfiguration build() {
            return new CodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeConfiguration> {
        public Builder code(Code var1);

        default public Builder code(Consumer<Code.Builder> code) {
            return this.code((Code)((Code.Builder)Code.builder().applyMutation(code)).build());
        }

        public Builder runtime(String var1);

        public Builder runtime(AgentManagedRuntimeType var1);

        public Builder entryPoint(Collection<String> var1);

        public Builder entryPoint(String ... var1);
    }
}

