/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadIdentitiesResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListWorkloadIdentitiesResponse> {
    private static final SdkField<List<WorkloadIdentityType>> WORKLOAD_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workloadIdentities").getter(ListWorkloadIdentitiesResponse.getter(ListWorkloadIdentitiesResponse::workloadIdentities)).setter(ListWorkloadIdentitiesResponse.setter(Builder::workloadIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadIdentityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkloadIdentitiesResponse.getter(ListWorkloadIdentitiesResponse::nextToken)).setter(ListWorkloadIdentitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkloadIdentitiesResponse.memberNameToFieldInitializer();
    private final List<WorkloadIdentityType> workloadIdentities;
    private final String nextToken;

    private ListWorkloadIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.workloadIdentities = builder.workloadIdentities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkloadIdentities() {
        return this.workloadIdentities != null && !(this.workloadIdentities instanceof SdkAutoConstructList);
    }

    public final List<WorkloadIdentityType> workloadIdentities() {
        return this.workloadIdentities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadIdentities() ? this.workloadIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadIdentitiesResponse)) {
            return false;
        }
        ListWorkloadIdentitiesResponse other = (ListWorkloadIdentitiesResponse)((Object)obj);
        return this.hasWorkloadIdentities() == other.hasWorkloadIdentities() && Objects.equals(this.workloadIdentities(), other.workloadIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadIdentitiesResponse").add("WorkloadIdentities", this.hasWorkloadIdentities() ? this.workloadIdentities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workloadIdentities": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentities()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workloadIdentities", WORKLOAD_IDENTITIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadIdentitiesResponse, T> g) {
        return obj -> g.apply((ListWorkloadIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<WorkloadIdentityType> workloadIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadIdentitiesResponse model) {
            super(model);
            this.workloadIdentities(model.workloadIdentities);
            this.nextToken(model.nextToken);
        }

        public final List<WorkloadIdentityType.Builder> getWorkloadIdentities() {
            List<WorkloadIdentityType.Builder> result = WorkloadIdentityListCopier.copyToBuilder(this.workloadIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadIdentities(Collection<WorkloadIdentityType.BuilderImpl> workloadIdentities) {
            this.workloadIdentities = WorkloadIdentityListCopier.copyFromBuilder(workloadIdentities);
        }

        @Override
        public final Builder workloadIdentities(Collection<WorkloadIdentityType> workloadIdentities) {
            this.workloadIdentities = WorkloadIdentityListCopier.copy(workloadIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadIdentities(WorkloadIdentityType ... workloadIdentities) {
            this.workloadIdentities(Arrays.asList(workloadIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadIdentities(Consumer<WorkloadIdentityType.Builder> ... workloadIdentities) {
            this.workloadIdentities(Stream.of(workloadIdentities).map(c -> (WorkloadIdentityType)((WorkloadIdentityType.Builder)WorkloadIdentityType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkloadIdentitiesResponse build() {
            return new ListWorkloadIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadIdentitiesResponse> {
        public Builder workloadIdentities(Collection<WorkloadIdentityType> var1);

        public Builder workloadIdentities(WorkloadIdentityType ... var1);

        public Builder workloadIdentities(Consumer<WorkloadIdentityType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

