/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrowserNetworkMode {
    PUBLIC("PUBLIC"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrowserNetworkMode> VALUE_MAP;
    private final String value;

    private BrowserNetworkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrowserNetworkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrowserNetworkMode> knownValues() {
        EnumSet<BrowserNetworkMode> knownValues = EnumSet.allOf(BrowserNetworkMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrowserNetworkMode.class, BrowserNetworkMode::toString);
    }
}

