/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListMemoriesResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MemorySummary;

public class ListMemoriesPublisher
implements SdkPublisher<ListMemoriesResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListMemoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMemoriesPublisher(BedrockAgentCoreControlAsyncClient client, ListMemoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMemoriesPublisher(BedrockAgentCoreControlAsyncClient client, ListMemoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMemoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMemoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemorySummary> memories() {
        Function<ListMemoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.memories() != null) {
                return response.memories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMemoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMemoriesResponseFetcher
    implements AsyncPageFetcher<ListMemoriesResponse> {
        private ListMemoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListMemoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMemoriesResponse> nextPage(ListMemoriesResponse previousPage) {
            if (previousPage == null) {
                return ListMemoriesPublisher.this.client.listMemories(ListMemoriesPublisher.this.firstRequest);
            }
            return ListMemoriesPublisher.this.client.listMemories((ListMemoriesRequest)((Object)ListMemoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

