/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2AuthorizationServerMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Oauth2Discovery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Oauth2Discovery> {
    private static final SdkField<String> DISCOVERY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("discoveryUrl").getter(Oauth2Discovery.getter(Oauth2Discovery::discoveryUrl)).setter(Oauth2Discovery.setter(Builder::discoveryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryUrl").build()}).build();
    private static final SdkField<Oauth2AuthorizationServerMetadata> AUTHORIZATION_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizationServerMetadata").getter(Oauth2Discovery.getter(Oauth2Discovery::authorizationServerMetadata)).setter(Oauth2Discovery.setter(Builder::authorizationServerMetadata)).constructor(Oauth2AuthorizationServerMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationServerMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_URL_FIELD, AUTHORIZATION_SERVER_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Oauth2Discovery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String discoveryUrl;
    private final Oauth2AuthorizationServerMetadata authorizationServerMetadata;
    private final Type type;

    private Oauth2Discovery(BuilderImpl builder) {
        this.discoveryUrl = builder.discoveryUrl;
        this.authorizationServerMetadata = builder.authorizationServerMetadata;
        this.type = builder.type;
    }

    public final String discoveryUrl() {
        return this.discoveryUrl;
    }

    public final Oauth2AuthorizationServerMetadata authorizationServerMetadata() {
        return this.authorizationServerMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationServerMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Oauth2Discovery)) {
            return false;
        }
        Oauth2Discovery other = (Oauth2Discovery)obj;
        return Objects.equals(this.discoveryUrl(), other.discoveryUrl()) && Objects.equals(this.authorizationServerMetadata(), other.authorizationServerMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"Oauth2Discovery").add("DiscoveryUrl", (Object)this.discoveryUrl()).add("AuthorizationServerMetadata", (Object)this.authorizationServerMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "discoveryUrl": {
                return Optional.ofNullable(clazz.cast(this.discoveryUrl()));
            }
            case "authorizationServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.authorizationServerMetadata()));
            }
        }
        return Optional.empty();
    }

    public static Oauth2Discovery fromDiscoveryUrl(String discoveryUrl) {
        return (Oauth2Discovery)Oauth2Discovery.builder().discoveryUrl(discoveryUrl).build();
    }

    public static Oauth2Discovery fromAuthorizationServerMetadata(Oauth2AuthorizationServerMetadata authorizationServerMetadata) {
        return (Oauth2Discovery)Oauth2Discovery.builder().authorizationServerMetadata(authorizationServerMetadata).build();
    }

    public static Oauth2Discovery fromAuthorizationServerMetadata(Consumer<Oauth2AuthorizationServerMetadata.Builder> authorizationServerMetadata) {
        Oauth2AuthorizationServerMetadata.Builder builder = Oauth2AuthorizationServerMetadata.builder();
        authorizationServerMetadata.accept(builder);
        return Oauth2Discovery.fromAuthorizationServerMetadata((Oauth2AuthorizationServerMetadata)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("discoveryUrl", DISCOVERY_URL_FIELD);
        map.put("authorizationServerMetadata", AUTHORIZATION_SERVER_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Oauth2Discovery, T> g) {
        return obj -> g.apply((Oauth2Discovery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DISCOVERY_URL,
        AUTHORIZATION_SERVER_METADATA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String discoveryUrl;
        private Oauth2AuthorizationServerMetadata authorizationServerMetadata;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Oauth2Discovery model) {
            this.discoveryUrl(model.discoveryUrl);
            this.authorizationServerMetadata(model.authorizationServerMetadata);
        }

        public final String getDiscoveryUrl() {
            return this.discoveryUrl;
        }

        public final void setDiscoveryUrl(String discoveryUrl) {
            String oldValue = this.discoveryUrl;
            this.discoveryUrl = discoveryUrl;
            this.handleUnionValueChange(Type.DISCOVERY_URL, oldValue, this.discoveryUrl);
        }

        @Override
        public final Builder discoveryUrl(String discoveryUrl) {
            String oldValue = this.discoveryUrl;
            this.discoveryUrl = discoveryUrl;
            this.handleUnionValueChange(Type.DISCOVERY_URL, oldValue, this.discoveryUrl);
            return this;
        }

        public final Oauth2AuthorizationServerMetadata.Builder getAuthorizationServerMetadata() {
            return this.authorizationServerMetadata != null ? this.authorizationServerMetadata.toBuilder() : null;
        }

        public final void setAuthorizationServerMetadata(Oauth2AuthorizationServerMetadata.BuilderImpl authorizationServerMetadata) {
            Oauth2AuthorizationServerMetadata oldValue = this.authorizationServerMetadata;
            this.authorizationServerMetadata = authorizationServerMetadata != null ? authorizationServerMetadata.build() : null;
            this.handleUnionValueChange(Type.AUTHORIZATION_SERVER_METADATA, oldValue, this.authorizationServerMetadata);
        }

        @Override
        public final Builder authorizationServerMetadata(Oauth2AuthorizationServerMetadata authorizationServerMetadata) {
            Oauth2AuthorizationServerMetadata oldValue = this.authorizationServerMetadata;
            this.authorizationServerMetadata = authorizationServerMetadata;
            this.handleUnionValueChange(Type.AUTHORIZATION_SERVER_METADATA, oldValue, this.authorizationServerMetadata);
            return this;
        }

        public Oauth2Discovery build() {
            return new Oauth2Discovery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Oauth2Discovery> {
        public Builder discoveryUrl(String var1);

        public Builder authorizationServerMetadata(Oauth2AuthorizationServerMetadata var1);

        default public Builder authorizationServerMetadata(Consumer<Oauth2AuthorizationServerMetadata.Builder> authorizationServerMetadata) {
            return this.authorizationServerMetadata((Oauth2AuthorizationServerMetadata)((Oauth2AuthorizationServerMetadata.Builder)Oauth2AuthorizationServerMetadata.builder().applyMutation(authorizationServerMetadata)).build());
        }
    }
}

