/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkMode {
    PUBLIC("PUBLIC"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkMode> VALUE_MAP;
    private final String value;

    private NetworkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkMode> knownValues() {
        EnumSet<NetworkMode> knownValues = EnumSet.allOf(NetworkMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkMode.class, NetworkMode::toString);
    }
}

