/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserNetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserSigningConfigInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RecordingConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBrowserRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateBrowserRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateBrowserRequest.getter(CreateBrowserRequest::name)).setter(CreateBrowserRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateBrowserRequest.getter(CreateBrowserRequest::description)).setter(CreateBrowserRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(CreateBrowserRequest.getter(CreateBrowserRequest::executionRoleArn)).setter(CreateBrowserRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<BrowserNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateBrowserRequest.getter(CreateBrowserRequest::networkConfiguration)).setter(CreateBrowserRequest.setter(Builder::networkConfiguration)).constructor(BrowserNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<RecordingConfig> RECORDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recording").getter(CreateBrowserRequest.getter(CreateBrowserRequest::recording)).setter(CreateBrowserRequest.setter(Builder::recording)).constructor(RecordingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recording").build()}).build();
    private static final SdkField<BrowserSigningConfigInput> BROWSER_SIGNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("browserSigning").getter(CreateBrowserRequest.getter(CreateBrowserRequest::browserSigning)).setter(CreateBrowserRequest.setter(Builder::browserSigning)).constructor(BrowserSigningConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSigning").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateBrowserRequest.getter(CreateBrowserRequest::clientToken)).setter(CreateBrowserRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateBrowserRequest.getter(CreateBrowserRequest::tags)).setter(CreateBrowserRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EXECUTION_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, RECORDING_FIELD, BROWSER_SIGNING_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBrowserRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String executionRoleArn;
    private final BrowserNetworkConfiguration networkConfiguration;
    private final RecordingConfig recording;
    private final BrowserSigningConfigInput browserSigning;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateBrowserRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.executionRoleArn = builder.executionRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.recording = builder.recording;
        this.browserSigning = builder.browserSigning;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final BrowserNetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final RecordingConfig recording() {
        return this.recording;
    }

    public final BrowserSigningConfigInput browserSigning() {
        return this.browserSigning;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.recording());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserSigning());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrowserRequest)) {
            return false;
        }
        CreateBrowserRequest other = (CreateBrowserRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.recording(), other.recording()) && Objects.equals(this.browserSigning(), other.browserSigning()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBrowserRequest").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Recording", (Object)this.recording()).add("BrowserSigning", (Object)this.browserSigning()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "recording": {
                return Optional.ofNullable(clazz.cast(this.recording()));
            }
            case "browserSigning": {
                return Optional.ofNullable(clazz.cast(this.browserSigning()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("recording", RECORDING_FIELD);
        map.put("browserSigning", BROWSER_SIGNING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrowserRequest, T> g) {
        return obj -> g.apply((CreateBrowserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String executionRoleArn;
        private BrowserNetworkConfiguration networkConfiguration;
        private RecordingConfig recording;
        private BrowserSigningConfigInput browserSigning;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrowserRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.executionRoleArn(model.executionRoleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.recording(model.recording);
            this.browserSigning(model.browserSigning);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final BrowserNetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(BrowserNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(BrowserNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final RecordingConfig.Builder getRecording() {
            return this.recording != null ? this.recording.toBuilder() : null;
        }

        public final void setRecording(RecordingConfig.BuilderImpl recording) {
            this.recording = recording != null ? recording.build() : null;
        }

        @Override
        public final Builder recording(RecordingConfig recording) {
            this.recording = recording;
            return this;
        }

        public final BrowserSigningConfigInput.Builder getBrowserSigning() {
            return this.browserSigning != null ? this.browserSigning.toBuilder() : null;
        }

        public final void setBrowserSigning(BrowserSigningConfigInput.BuilderImpl browserSigning) {
            this.browserSigning = browserSigning != null ? browserSigning.build() : null;
        }

        @Override
        public final Builder browserSigning(BrowserSigningConfigInput browserSigning) {
            this.browserSigning = browserSigning;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBrowserRequest build() {
            return new CreateBrowserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBrowserRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder executionRoleArn(String var1);

        public Builder networkConfiguration(BrowserNetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<BrowserNetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((BrowserNetworkConfiguration)((BrowserNetworkConfiguration.Builder)BrowserNetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder recording(RecordingConfig var1);

        default public Builder recording(Consumer<RecordingConfig.Builder> recording) {
            return this.recording((RecordingConfig)((RecordingConfig.Builder)RecordingConfig.builder().applyMutation(recording)).build());
        }

        public Builder browserSigning(BrowserSigningConfigInput var1);

        default public Builder browserSigning(Consumer<BrowserSigningConfigInput.Builder> browserSigning) {
            return this.browserSigning((BrowserSigningConfigInput)((BrowserSigningConfigInput.Builder)BrowserSigningConfigInput.builder().applyMutation(browserSigning)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

