/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOauth2CredentialProvidersResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2CredentialProviderItem;

public class ListOauth2CredentialProvidersPublisher
implements SdkPublisher<ListOauth2CredentialProvidersResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListOauth2CredentialProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOauth2CredentialProvidersPublisher(BedrockAgentCoreControlAsyncClient client, ListOauth2CredentialProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOauth2CredentialProvidersPublisher(BedrockAgentCoreControlAsyncClient client, ListOauth2CredentialProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOauth2CredentialProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOauth2CredentialProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Oauth2CredentialProviderItem> credentialProviders() {
        Function<ListOauth2CredentialProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.credentialProviders() != null) {
                return response.credentialProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOauth2CredentialProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOauth2CredentialProvidersResponseFetcher
    implements AsyncPageFetcher<ListOauth2CredentialProvidersResponse> {
        private ListOauth2CredentialProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListOauth2CredentialProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOauth2CredentialProvidersResponse> nextPage(ListOauth2CredentialProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListOauth2CredentialProvidersPublisher.this.client.listOauth2CredentialProviders(ListOauth2CredentialProvidersPublisher.this.firstRequest);
            }
            return ListOauth2CredentialProvidersPublisher.this.client.listOauth2CredentialProviders((ListOauth2CredentialProvidersRequest)((Object)ListOauth2CredentialProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

