/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MessageBasedTrigger;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TimeBasedTrigger;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TokenBasedTrigger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerCondition> {
    private static final SdkField<MessageBasedTrigger> MESSAGE_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageBasedTrigger").getter(TriggerCondition.getter(TriggerCondition::messageBasedTrigger)).setter(TriggerCondition.setter(Builder::messageBasedTrigger)).constructor(MessageBasedTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageBasedTrigger").build()}).build();
    private static final SdkField<TokenBasedTrigger> TOKEN_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenBasedTrigger").getter(TriggerCondition.getter(TriggerCondition::tokenBasedTrigger)).setter(TriggerCondition.setter(Builder::tokenBasedTrigger)).constructor(TokenBasedTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenBasedTrigger").build()}).build();
    private static final SdkField<TimeBasedTrigger> TIME_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBasedTrigger").getter(TriggerCondition.getter(TriggerCondition::timeBasedTrigger)).setter(TriggerCondition.setter(Builder::timeBasedTrigger)).constructor(TimeBasedTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedTrigger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_BASED_TRIGGER_FIELD, TOKEN_BASED_TRIGGER_FIELD, TIME_BASED_TRIGGER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TriggerCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MessageBasedTrigger messageBasedTrigger;
    private final TokenBasedTrigger tokenBasedTrigger;
    private final TimeBasedTrigger timeBasedTrigger;
    private final Type type;

    private TriggerCondition(BuilderImpl builder) {
        this.messageBasedTrigger = builder.messageBasedTrigger;
        this.tokenBasedTrigger = builder.tokenBasedTrigger;
        this.timeBasedTrigger = builder.timeBasedTrigger;
        this.type = builder.type;
    }

    public final MessageBasedTrigger messageBasedTrigger() {
        return this.messageBasedTrigger;
    }

    public final TokenBasedTrigger tokenBasedTrigger() {
        return this.tokenBasedTrigger;
    }

    public final TimeBasedTrigger timeBasedTrigger() {
        return this.timeBasedTrigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBasedTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenBasedTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBasedTrigger());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerCondition)) {
            return false;
        }
        TriggerCondition other = (TriggerCondition)obj;
        return Objects.equals(this.messageBasedTrigger(), other.messageBasedTrigger()) && Objects.equals(this.tokenBasedTrigger(), other.tokenBasedTrigger()) && Objects.equals(this.timeBasedTrigger(), other.timeBasedTrigger());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerCondition").add("MessageBasedTrigger", (Object)this.messageBasedTrigger()).add("TokenBasedTrigger", (Object)this.tokenBasedTrigger()).add("TimeBasedTrigger", (Object)this.timeBasedTrigger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.messageBasedTrigger()));
            }
            case "tokenBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.tokenBasedTrigger()));
            }
            case "timeBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.timeBasedTrigger()));
            }
        }
        return Optional.empty();
    }

    public static TriggerCondition fromMessageBasedTrigger(MessageBasedTrigger messageBasedTrigger) {
        return (TriggerCondition)TriggerCondition.builder().messageBasedTrigger(messageBasedTrigger).build();
    }

    public static TriggerCondition fromMessageBasedTrigger(Consumer<MessageBasedTrigger.Builder> messageBasedTrigger) {
        MessageBasedTrigger.Builder builder = MessageBasedTrigger.builder();
        messageBasedTrigger.accept(builder);
        return TriggerCondition.fromMessageBasedTrigger((MessageBasedTrigger)builder.build());
    }

    public static TriggerCondition fromTokenBasedTrigger(TokenBasedTrigger tokenBasedTrigger) {
        return (TriggerCondition)TriggerCondition.builder().tokenBasedTrigger(tokenBasedTrigger).build();
    }

    public static TriggerCondition fromTokenBasedTrigger(Consumer<TokenBasedTrigger.Builder> tokenBasedTrigger) {
        TokenBasedTrigger.Builder builder = TokenBasedTrigger.builder();
        tokenBasedTrigger.accept(builder);
        return TriggerCondition.fromTokenBasedTrigger((TokenBasedTrigger)builder.build());
    }

    public static TriggerCondition fromTimeBasedTrigger(TimeBasedTrigger timeBasedTrigger) {
        return (TriggerCondition)TriggerCondition.builder().timeBasedTrigger(timeBasedTrigger).build();
    }

    public static TriggerCondition fromTimeBasedTrigger(Consumer<TimeBasedTrigger.Builder> timeBasedTrigger) {
        TimeBasedTrigger.Builder builder = TimeBasedTrigger.builder();
        timeBasedTrigger.accept(builder);
        return TriggerCondition.fromTimeBasedTrigger((TimeBasedTrigger)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageBasedTrigger", MESSAGE_BASED_TRIGGER_FIELD);
        map.put("tokenBasedTrigger", TOKEN_BASED_TRIGGER_FIELD);
        map.put("timeBasedTrigger", TIME_BASED_TRIGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TriggerCondition, T> g) {
        return obj -> g.apply((TriggerCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MESSAGE_BASED_TRIGGER,
        TOKEN_BASED_TRIGGER,
        TIME_BASED_TRIGGER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private MessageBasedTrigger messageBasedTrigger;
        private TokenBasedTrigger tokenBasedTrigger;
        private TimeBasedTrigger timeBasedTrigger;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerCondition model) {
            this.messageBasedTrigger(model.messageBasedTrigger);
            this.tokenBasedTrigger(model.tokenBasedTrigger);
            this.timeBasedTrigger(model.timeBasedTrigger);
        }

        public final MessageBasedTrigger.Builder getMessageBasedTrigger() {
            return this.messageBasedTrigger != null ? this.messageBasedTrigger.toBuilder() : null;
        }

        public final void setMessageBasedTrigger(MessageBasedTrigger.BuilderImpl messageBasedTrigger) {
            MessageBasedTrigger oldValue = this.messageBasedTrigger;
            this.messageBasedTrigger = messageBasedTrigger != null ? messageBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.MESSAGE_BASED_TRIGGER, oldValue, this.messageBasedTrigger);
        }

        @Override
        public final Builder messageBasedTrigger(MessageBasedTrigger messageBasedTrigger) {
            MessageBasedTrigger oldValue = this.messageBasedTrigger;
            this.messageBasedTrigger = messageBasedTrigger;
            this.handleUnionValueChange(Type.MESSAGE_BASED_TRIGGER, oldValue, this.messageBasedTrigger);
            return this;
        }

        public final TokenBasedTrigger.Builder getTokenBasedTrigger() {
            return this.tokenBasedTrigger != null ? this.tokenBasedTrigger.toBuilder() : null;
        }

        public final void setTokenBasedTrigger(TokenBasedTrigger.BuilderImpl tokenBasedTrigger) {
            TokenBasedTrigger oldValue = this.tokenBasedTrigger;
            this.tokenBasedTrigger = tokenBasedTrigger != null ? tokenBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.TOKEN_BASED_TRIGGER, oldValue, this.tokenBasedTrigger);
        }

        @Override
        public final Builder tokenBasedTrigger(TokenBasedTrigger tokenBasedTrigger) {
            TokenBasedTrigger oldValue = this.tokenBasedTrigger;
            this.tokenBasedTrigger = tokenBasedTrigger;
            this.handleUnionValueChange(Type.TOKEN_BASED_TRIGGER, oldValue, this.tokenBasedTrigger);
            return this;
        }

        public final TimeBasedTrigger.Builder getTimeBasedTrigger() {
            return this.timeBasedTrigger != null ? this.timeBasedTrigger.toBuilder() : null;
        }

        public final void setTimeBasedTrigger(TimeBasedTrigger.BuilderImpl timeBasedTrigger) {
            TimeBasedTrigger oldValue = this.timeBasedTrigger;
            this.timeBasedTrigger = timeBasedTrigger != null ? timeBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.TIME_BASED_TRIGGER, oldValue, this.timeBasedTrigger);
        }

        @Override
        public final Builder timeBasedTrigger(TimeBasedTrigger timeBasedTrigger) {
            TimeBasedTrigger oldValue = this.timeBasedTrigger;
            this.timeBasedTrigger = timeBasedTrigger;
            this.handleUnionValueChange(Type.TIME_BASED_TRIGGER, oldValue, this.timeBasedTrigger);
            return this;
        }

        public TriggerCondition build() {
            return new TriggerCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerCondition> {
        public Builder messageBasedTrigger(MessageBasedTrigger var1);

        default public Builder messageBasedTrigger(Consumer<MessageBasedTrigger.Builder> messageBasedTrigger) {
            return this.messageBasedTrigger((MessageBasedTrigger)((MessageBasedTrigger.Builder)MessageBasedTrigger.builder().applyMutation(messageBasedTrigger)).build());
        }

        public Builder tokenBasedTrigger(TokenBasedTrigger var1);

        default public Builder tokenBasedTrigger(Consumer<TokenBasedTrigger.Builder> tokenBasedTrigger) {
            return this.tokenBasedTrigger((TokenBasedTrigger)((TokenBasedTrigger.Builder)TokenBasedTrigger.builder().applyMutation(tokenBasedTrigger)).build());
        }

        public Builder timeBasedTrigger(TimeBasedTrigger var1);

        default public Builder timeBasedTrigger(Consumer<TimeBasedTrigger.Builder> timeBasedTrigger) {
            return this.timeBasedTrigger((TimeBasedTrigger)((TimeBasedTrigger.Builder)TimeBasedTrigger.builder().applyMutation(timeBasedTrigger)).build());
        }
    }
}

