/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OverrideType {
    SEMANTIC_OVERRIDE("SEMANTIC_OVERRIDE"),
    SUMMARY_OVERRIDE("SUMMARY_OVERRIDE"),
    USER_PREFERENCE_OVERRIDE("USER_PREFERENCE_OVERRIDE"),
    SELF_MANAGED("SELF_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OverrideType> VALUE_MAP;
    private final String value;

    private OverrideType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OverrideType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OverrideType> knownValues() {
        EnumSet<OverrideType> knownValues = EnumSet.allOf(OverrideType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OverrideType.class, OverrideType::toString);
    }
}

