/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeInterpreterSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListCodeInterpretersResponse;

public class ListCodeInterpretersPublisher
implements SdkPublisher<ListCodeInterpretersResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListCodeInterpretersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCodeInterpretersPublisher(BedrockAgentCoreControlAsyncClient client, ListCodeInterpretersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCodeInterpretersPublisher(BedrockAgentCoreControlAsyncClient client, ListCodeInterpretersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCodeInterpretersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCodeInterpretersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CodeInterpreterSummary> codeInterpreterSummaries() {
        Function<ListCodeInterpretersResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeInterpreterSummaries() != null) {
                return response.codeInterpreterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCodeInterpretersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCodeInterpretersResponseFetcher
    implements AsyncPageFetcher<ListCodeInterpretersResponse> {
        private ListCodeInterpretersResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeInterpretersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCodeInterpretersResponse> nextPage(ListCodeInterpretersResponse previousPage) {
            if (previousPage == null) {
                return ListCodeInterpretersPublisher.this.client.listCodeInterpreters(ListCodeInterpretersPublisher.this.firstRequest);
            }
            return ListCodeInterpretersPublisher.this.client.listCodeInterpreters((ListCodeInterpretersRequest)((Object)ListCodeInterpretersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

