/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfigurationsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.StatusReasonsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayTarget> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayArn").getter(GatewayTarget.getter(GatewayTarget::gatewayArn)).setter(GatewayTarget.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(GatewayTarget.getter(GatewayTarget::targetId)).setter(GatewayTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GatewayTarget.getter(GatewayTarget::createdAt)).setter(GatewayTarget.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GatewayTarget.getter(GatewayTarget::updatedAt)).setter(GatewayTarget.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GatewayTarget.getter(GatewayTarget::statusAsString)).setter(GatewayTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusReasons").getter(GatewayTarget.getter(GatewayTarget::statusReasons)).setter(GatewayTarget.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GatewayTarget.getter(GatewayTarget::name)).setter(GatewayTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GatewayTarget.getter(GatewayTarget::description)).setter(GatewayTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetConfiguration").getter(GatewayTarget.getter(GatewayTarget::targetConfiguration)).setter(GatewayTarget.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build()}).build();
    private static final SdkField<List<CredentialProviderConfiguration>> CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentialProviderConfigurations").getter(GatewayTarget.getter(GatewayTarget::credentialProviderConfigurations)).setter(GatewayTarget.setter(Builder::credentialProviderConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CredentialProviderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_SYNCHRONIZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSynchronizedAt").getter(GatewayTarget.getter(GatewayTarget::lastSynchronizedAt)).setter(GatewayTarget.setter(Builder::lastSynchronizedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSynchronizedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TARGET_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TARGET_CONFIGURATION_FIELD, CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD, LAST_SYNCHRONIZED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayArn;
    private final String targetId;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String status;
    private final List<String> statusReasons;
    private final String name;
    private final String description;
    private final TargetConfiguration targetConfiguration;
    private final List<CredentialProviderConfiguration> credentialProviderConfigurations;
    private final Instant lastSynchronizedAt;

    private GatewayTarget(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.targetId = builder.targetId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.name = builder.name;
        this.description = builder.description;
        this.targetConfiguration = builder.targetConfiguration;
        this.credentialProviderConfigurations = builder.credentialProviderConfigurations;
        this.lastSynchronizedAt = builder.lastSynchronizedAt;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasons() {
        return this.statusReasons;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final boolean hasCredentialProviderConfigurations() {
        return this.credentialProviderConfigurations != null && !(this.credentialProviderConfigurations instanceof SdkAutoConstructList);
    }

    public final List<CredentialProviderConfiguration> credentialProviderConfigurations() {
        return this.credentialProviderConfigurations;
    }

    public final Instant lastSynchronizedAt() {
        return this.lastSynchronizedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialProviderConfigurations() ? this.credentialProviderConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSynchronizedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayTarget)) {
            return false;
        }
        GatewayTarget other = (GatewayTarget)obj;
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && this.hasCredentialProviderConfigurations() == other.hasCredentialProviderConfigurations() && Objects.equals(this.credentialProviderConfigurations(), other.credentialProviderConfigurations()) && Objects.equals(this.lastSynchronizedAt(), other.lastSynchronizedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayTarget").add("GatewayArn", (Object)this.gatewayArn()).add("TargetId", (Object)this.targetId()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetConfiguration", (Object)this.targetConfiguration()).add("CredentialProviderConfigurations", this.hasCredentialProviderConfigurations() ? this.credentialProviderConfigurations() : null).add("LastSynchronizedAt", (Object)this.lastSynchronizedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "credentialProviderConfigurations": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderConfigurations()));
            }
            case "lastSynchronizedAt": {
                return Optional.ofNullable(clazz.cast(this.lastSynchronizedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("credentialProviderConfigurations", CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD);
        map.put("lastSynchronizedAt", LAST_SYNCHRONIZED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayTarget, T> g) {
        return obj -> g.apply((GatewayTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String targetId;
        private Instant createdAt;
        private Instant updatedAt;
        private String status;
        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String description;
        private TargetConfiguration targetConfiguration;
        private List<CredentialProviderConfiguration> credentialProviderConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Instant lastSynchronizedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayTarget model) {
            this.gatewayArn(model.gatewayArn);
            this.targetId(model.targetId);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
            this.statusReasons(model.statusReasons);
            this.name(model.name);
            this.description(model.description);
            this.targetConfiguration(model.targetConfiguration);
            this.credentialProviderConfigurations(model.credentialProviderConfigurations);
            this.lastSynchronizedAt(model.lastSynchronizedAt);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final List<CredentialProviderConfiguration.Builder> getCredentialProviderConfigurations() {
            List<CredentialProviderConfiguration.Builder> result = CredentialProviderConfigurationsCopier.copyToBuilder(this.credentialProviderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviderConfigurations(Collection<CredentialProviderConfiguration.BuilderImpl> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copyFromBuilder(credentialProviderConfigurations);
        }

        @Override
        public final Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copy(credentialProviderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(CredentialProviderConfiguration ... credentialProviderConfigurations) {
            this.credentialProviderConfigurations(Arrays.asList(credentialProviderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(Consumer<CredentialProviderConfiguration.Builder> ... credentialProviderConfigurations) {
            this.credentialProviderConfigurations(Stream.of(credentialProviderConfigurations).map(c -> (CredentialProviderConfiguration)((CredentialProviderConfiguration.Builder)CredentialProviderConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastSynchronizedAt() {
            return this.lastSynchronizedAt;
        }

        public final void setLastSynchronizedAt(Instant lastSynchronizedAt) {
            this.lastSynchronizedAt = lastSynchronizedAt;
        }

        @Override
        public final Builder lastSynchronizedAt(Instant lastSynchronizedAt) {
            this.lastSynchronizedAt = lastSynchronizedAt;
            return this;
        }

        public GatewayTarget build() {
            return new GatewayTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayTarget> {
        public Builder gatewayArn(String var1);

        public Builder targetId(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder statusReasons(Collection<String> var1);

        public Builder statusReasons(String ... var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> var1);

        public Builder credentialProviderConfigurations(CredentialProviderConfiguration ... var1);

        public Builder credentialProviderConfigurations(Consumer<CredentialProviderConfiguration.Builder> ... var1);

        public Builder lastSynchronizedAt(Instant var1);
    }
}

