/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeEndpointStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgentRuntimeEndpointResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetAgentRuntimeEndpointResponse> {
    private static final SdkField<String> LIVE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("liveVersion").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::liveVersion)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::liveVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveVersion").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetVersion").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::targetVersion)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeEndpointArn").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::agentRuntimeEndpointArn)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeEndpointArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::agentRuntimeArn)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::description)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::statusAsString)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::createdAt)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::lastUpdatedAt)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::failureReason)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::name)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAgentRuntimeEndpointResponse.getter(GetAgentRuntimeEndpointResponse::id)).setter(GetAgentRuntimeEndpointResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIVE_VERSION_FIELD, TARGET_VERSION_FIELD, AGENT_RUNTIME_ENDPOINT_ARN_FIELD, AGENT_RUNTIME_ARN_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_REASON_FIELD, NAME_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAgentRuntimeEndpointResponse.memberNameToFieldInitializer();
    private final String liveVersion;
    private final String targetVersion;
    private final String agentRuntimeEndpointArn;
    private final String agentRuntimeArn;
    private final String description;
    private final String status;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String failureReason;
    private final String name;
    private final String id;

    private GetAgentRuntimeEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.liveVersion = builder.liveVersion;
        this.targetVersion = builder.targetVersion;
        this.agentRuntimeEndpointArn = builder.agentRuntimeEndpointArn;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.description = builder.description;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureReason = builder.failureReason;
        this.name = builder.name;
        this.id = builder.id;
    }

    public final String liveVersion() {
        return this.liveVersion;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final String agentRuntimeEndpointArn() {
        return this.agentRuntimeEndpointArn;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String description() {
        return this.description;
    }

    public final AgentRuntimeEndpointStatus status() {
        return AgentRuntimeEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.liveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentRuntimeEndpointResponse)) {
            return false;
        }
        GetAgentRuntimeEndpointResponse other = (GetAgentRuntimeEndpointResponse)((Object)obj);
        return Objects.equals(this.liveVersion(), other.liveVersion()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.agentRuntimeEndpointArn(), other.agentRuntimeEndpointArn()) && Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgentRuntimeEndpointResponse").add("LiveVersion", (Object)this.liveVersion()).add("TargetVersion", (Object)this.targetVersion()).add("AgentRuntimeEndpointArn", (Object)this.agentRuntimeEndpointArn()).add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("FailureReason", (Object)this.failureReason()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "liveVersion": {
                return Optional.ofNullable(clazz.cast(this.liveVersion()));
            }
            case "targetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "agentRuntimeEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeEndpointArn()));
            }
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("liveVersion", LIVE_VERSION_FIELD);
        map.put("targetVersion", TARGET_VERSION_FIELD);
        map.put("agentRuntimeEndpointArn", AGENT_RUNTIME_ENDPOINT_ARN_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("name", NAME_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentRuntimeEndpointResponse, T> g) {
        return obj -> g.apply((GetAgentRuntimeEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String liveVersion;
        private String targetVersion;
        private String agentRuntimeEndpointArn;
        private String agentRuntimeArn;
        private String description;
        private String status;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String failureReason;
        private String name;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentRuntimeEndpointResponse model) {
            super(model);
            this.liveVersion(model.liveVersion);
            this.targetVersion(model.targetVersion);
            this.agentRuntimeEndpointArn(model.agentRuntimeEndpointArn);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.description(model.description);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.failureReason(model.failureReason);
            this.name(model.name);
            this.id(model.id);
        }

        public final String getLiveVersion() {
            return this.liveVersion;
        }

        public final void setLiveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
        }

        @Override
        public final Builder liveVersion(String liveVersion) {
            this.liveVersion = liveVersion;
            return this;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final String getAgentRuntimeEndpointArn() {
            return this.agentRuntimeEndpointArn;
        }

        public final void setAgentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
        }

        @Override
        public final Builder agentRuntimeEndpointArn(String agentRuntimeEndpointArn) {
            this.agentRuntimeEndpointArn = agentRuntimeEndpointArn;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentRuntimeEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public GetAgentRuntimeEndpointResponse build() {
            return new GetAgentRuntimeEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgentRuntimeEndpointResponse> {
        public Builder liveVersion(String var1);

        public Builder targetVersion(String var1);

        public Builder agentRuntimeEndpointArn(String var1);

        public Builder agentRuntimeArn(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AgentRuntimeEndpointStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder failureReason(String var1);

        public Builder name(String var1);

        public Builder id(String var1);
    }
}

