/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ResourceOauth2ReturnUrlListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkloadIdentityResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, UpdateWorkloadIdentityResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateWorkloadIdentityResponse.getter(UpdateWorkloadIdentityResponse::name)).setter(UpdateWorkloadIdentityResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> WORKLOAD_IDENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadIdentityArn").getter(UpdateWorkloadIdentityResponse.getter(UpdateWorkloadIdentityResponse::workloadIdentityArn)).setter(UpdateWorkloadIdentityResponse.setter(Builder::workloadIdentityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityArn").build()}).build();
    private static final SdkField<List<String>> ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedResourceOauth2ReturnUrls").getter(UpdateWorkloadIdentityResponse.getter(UpdateWorkloadIdentityResponse::allowedResourceOauth2ReturnUrls)).setter(UpdateWorkloadIdentityResponse.setter(Builder::allowedResourceOauth2ReturnUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResourceOauth2ReturnUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(UpdateWorkloadIdentityResponse.getter(UpdateWorkloadIdentityResponse::createdTime)).setter(UpdateWorkloadIdentityResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(UpdateWorkloadIdentityResponse.getter(UpdateWorkloadIdentityResponse::lastUpdatedTime)).setter(UpdateWorkloadIdentityResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WORKLOAD_IDENTITY_ARN_FIELD, ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkloadIdentityResponse.memberNameToFieldInitializer();
    private final String name;
    private final String workloadIdentityArn;
    private final List<String> allowedResourceOauth2ReturnUrls;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;

    private UpdateWorkloadIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.workloadIdentityArn = builder.workloadIdentityArn;
        this.allowedResourceOauth2ReturnUrls = builder.allowedResourceOauth2ReturnUrls;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String name() {
        return this.name;
    }

    public final String workloadIdentityArn() {
        return this.workloadIdentityArn;
    }

    public final boolean hasAllowedResourceOauth2ReturnUrls() {
        return this.allowedResourceOauth2ReturnUrls != null && !(this.allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList);
    }

    public final List<String> allowedResourceOauth2ReturnUrls() {
        return this.allowedResourceOauth2ReturnUrls;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadIdentityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedResourceOauth2ReturnUrls() ? this.allowedResourceOauth2ReturnUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadIdentityResponse)) {
            return false;
        }
        UpdateWorkloadIdentityResponse other = (UpdateWorkloadIdentityResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.workloadIdentityArn(), other.workloadIdentityArn()) && this.hasAllowedResourceOauth2ReturnUrls() == other.hasAllowedResourceOauth2ReturnUrls() && Objects.equals(this.allowedResourceOauth2ReturnUrls(), other.allowedResourceOauth2ReturnUrls()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkloadIdentityResponse").add("Name", (Object)this.name()).add("WorkloadIdentityArn", (Object)this.workloadIdentityArn()).add("AllowedResourceOauth2ReturnUrls", this.hasAllowedResourceOauth2ReturnUrls() ? this.allowedResourceOauth2ReturnUrls() : null).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "workloadIdentityArn": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentityArn()));
            }
            case "allowedResourceOauth2ReturnUrls": {
                return Optional.ofNullable(clazz.cast(this.allowedResourceOauth2ReturnUrls()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("workloadIdentityArn", WORKLOAD_IDENTITY_ARN_FIELD);
        map.put("allowedResourceOauth2ReturnUrls", ALLOWED_RESOURCE_OAUTH2_RETURN_URLS_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadIdentityResponse, T> g) {
        return obj -> g.apply((UpdateWorkloadIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String name;
        private String workloadIdentityArn;
        private List<String> allowedResourceOauth2ReturnUrls = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadIdentityResponse model) {
            super(model);
            this.name(model.name);
            this.workloadIdentityArn(model.workloadIdentityArn);
            this.allowedResourceOauth2ReturnUrls(model.allowedResourceOauth2ReturnUrls);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkloadIdentityArn() {
            return this.workloadIdentityArn;
        }

        public final void setWorkloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
        }

        @Override
        public final Builder workloadIdentityArn(String workloadIdentityArn) {
            this.workloadIdentityArn = workloadIdentityArn;
            return this;
        }

        public final Collection<String> getAllowedResourceOauth2ReturnUrls() {
            if (this.allowedResourceOauth2ReturnUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedResourceOauth2ReturnUrls;
        }

        public final void setAllowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
        }

        @Override
        public final Builder allowedResourceOauth2ReturnUrls(Collection<String> allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls = ResourceOauth2ReturnUrlListTypeCopier.copy(allowedResourceOauth2ReturnUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResourceOauth2ReturnUrls(String ... allowedResourceOauth2ReturnUrls) {
            this.allowedResourceOauth2ReturnUrls(Arrays.asList(allowedResourceOauth2ReturnUrls));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public UpdateWorkloadIdentityResponse build() {
            return new UpdateWorkloadIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkloadIdentityResponse> {
        public Builder name(String var1);

        public Builder workloadIdentityArn(String var1);

        public Builder allowedResourceOauth2ReturnUrls(Collection<String> var1);

        public Builder allowedResourceOauth2ReturnUrls(String ... var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

