/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBrowserResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteBrowserResponse> {
    private static final SdkField<String> BROWSER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserId").getter(DeleteBrowserResponse.getter(DeleteBrowserResponse::browserId)).setter(DeleteBrowserResponse.setter(Builder::browserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteBrowserResponse.getter(DeleteBrowserResponse::statusAsString)).setter(DeleteBrowserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DeleteBrowserResponse.getter(DeleteBrowserResponse::lastUpdatedAt)).setter(DeleteBrowserResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_ID_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteBrowserResponse.memberNameToFieldInitializer();
    private final String browserId;
    private final String status;
    private final Instant lastUpdatedAt;

    private DeleteBrowserResponse(BuilderImpl builder) {
        super(builder);
        this.browserId = builder.browserId;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String browserId() {
        return this.browserId;
    }

    public final BrowserStatus status() {
        return BrowserStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBrowserResponse)) {
            return false;
        }
        DeleteBrowserResponse other = (DeleteBrowserResponse)((Object)obj);
        return Objects.equals(this.browserId(), other.browserId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBrowserResponse").add("BrowserId", (Object)this.browserId()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserId": {
                return Optional.ofNullable(clazz.cast(this.browserId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserId", BROWSER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBrowserResponse, T> g) {
        return obj -> g.apply((DeleteBrowserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String browserId;
        private String status;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBrowserResponse model) {
            super(model);
            this.browserId(model.browserId);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getBrowserId() {
            return this.browserId;
        }

        public final void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        @Override
        public final Builder browserId(String browserId) {
            this.browserId = browserId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public DeleteBrowserResponse build() {
            return new DeleteBrowserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBrowserResponse> {
        public Builder browserId(String var1);

        public Builder status(String var1);

        public Builder status(BrowserStatus var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

