/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAgentRuntimeEndpointRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, DeleteAgentRuntimeEndpointRequest> {
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(DeleteAgentRuntimeEndpointRequest.getter(DeleteAgentRuntimeEndpointRequest::agentRuntimeId)).setter(DeleteAgentRuntimeEndpointRequest.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(DeleteAgentRuntimeEndpointRequest.getter(DeleteAgentRuntimeEndpointRequest::endpointName)).setter(DeleteAgentRuntimeEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteAgentRuntimeEndpointRequest.getter(DeleteAgentRuntimeEndpointRequest::clientToken)).setter(DeleteAgentRuntimeEndpointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ID_FIELD, ENDPOINT_NAME_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAgentRuntimeEndpointRequest.memberNameToFieldInitializer();
    private final String agentRuntimeId;
    private final String endpointName;
    private final String clientToken;

    private DeleteAgentRuntimeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeId = builder.agentRuntimeId;
        this.endpointName = builder.endpointName;
        this.clientToken = builder.clientToken;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentRuntimeEndpointRequest)) {
            return false;
        }
        DeleteAgentRuntimeEndpointRequest other = (DeleteAgentRuntimeEndpointRequest)((Object)obj);
        return Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAgentRuntimeEndpointRequest").add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("EndpointName", (Object)(this.endpointName() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentRuntimeEndpointRequest, T> g) {
        return obj -> g.apply((DeleteAgentRuntimeEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String agentRuntimeId;
        private String endpointName;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentRuntimeEndpointRequest model) {
            super(model);
            this.agentRuntimeId(model.agentRuntimeId);
            this.endpointName(model.endpointName);
            this.clientToken(model.clientToken);
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAgentRuntimeEndpointRequest build() {
            return new DeleteAgentRuntimeEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAgentRuntimeEndpointRequest> {
        public Builder agentRuntimeId(String var1);

        public Builder endpointName(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

