/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TargetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SynchronizeGatewayTargetsRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, SynchronizeGatewayTargetsRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayIdentifier").getter(SynchronizeGatewayTargetsRequest.getter(SynchronizeGatewayTargetsRequest::gatewayIdentifier)).setter(SynchronizeGatewayTargetsRequest.setter(Builder::gatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()}).build();
    private static final SdkField<List<String>> TARGET_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetIdList").getter(SynchronizeGatewayTargetsRequest.getter(SynchronizeGatewayTargetsRequest::targetIdList)).setter(SynchronizeGatewayTargetsRequest.setter(Builder::targetIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD, TARGET_ID_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SynchronizeGatewayTargetsRequest.memberNameToFieldInitializer();
    private final String gatewayIdentifier;
    private final List<String> targetIdList;

    private SynchronizeGatewayTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.targetIdList = builder.targetIdList;
    }

    public final String gatewayIdentifier() {
        return this.gatewayIdentifier;
    }

    public final boolean hasTargetIdList() {
        return this.targetIdList != null && !(this.targetIdList instanceof SdkAutoConstructList);
    }

    public final List<String> targetIdList() {
        return this.targetIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIdList() ? this.targetIdList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SynchronizeGatewayTargetsRequest)) {
            return false;
        }
        SynchronizeGatewayTargetsRequest other = (SynchronizeGatewayTargetsRequest)((Object)obj);
        return Objects.equals(this.gatewayIdentifier(), other.gatewayIdentifier()) && this.hasTargetIdList() == other.hasTargetIdList() && Objects.equals(this.targetIdList(), other.targetIdList());
    }

    public final String toString() {
        return ToString.builder((String)"SynchronizeGatewayTargetsRequest").add("GatewayIdentifier", (Object)this.gatewayIdentifier()).add("TargetIdList", this.hasTargetIdList() ? this.targetIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.gatewayIdentifier()));
            }
            case "targetIdList": {
                return Optional.ofNullable(clazz.cast(this.targetIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("targetIdList", TARGET_ID_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SynchronizeGatewayTargetsRequest, T> g) {
        return obj -> g.apply((SynchronizeGatewayTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String gatewayIdentifier;
        private List<String> targetIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SynchronizeGatewayTargetsRequest model) {
            super(model);
            this.gatewayIdentifier(model.gatewayIdentifier);
            this.targetIdList(model.targetIdList);
        }

        public final String getGatewayIdentifier() {
            return this.gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final Collection<String> getTargetIdList() {
            if (this.targetIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetIdList;
        }

        public final void setTargetIdList(Collection<String> targetIdList) {
            this.targetIdList = TargetIdListCopier.copy(targetIdList);
        }

        @Override
        public final Builder targetIdList(Collection<String> targetIdList) {
            this.targetIdList = TargetIdListCopier.copy(targetIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdList(String ... targetIdList) {
            this.targetIdList(Arrays.asList(targetIdList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SynchronizeGatewayTargetsRequest build() {
            return new SynchronizeGatewayTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SynchronizeGatewayTargetsRequest> {
        public Builder gatewayIdentifier(String var1);

        public Builder targetIdList(Collection<String> var1);

        public Builder targetIdList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

