/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CredentialProviderType {
    GATEWAY_IAM_ROLE("GATEWAY_IAM_ROLE"),
    OAUTH("OAUTH"),
    API_KEY("API_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CredentialProviderType> VALUE_MAP;
    private final String value;

    private CredentialProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CredentialProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CredentialProviderType> knownValues() {
        EnumSet<CredentialProviderType> knownValues = EnumSet.allOf(CredentialProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CredentialProviderType.class, CredentialProviderType::toString);
    }
}

