/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGatewayResponse extends BedrockAgentCoreControlResponse implements
        ToCopyableBuilder<DeleteGatewayResponse.Builder, DeleteGatewayResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(DeleteGatewayResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeleteGatewayResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statusReasons")
            .getter(getter(DeleteGatewayResponse::statusReasons))
            .setter(setter(Builder::statusReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            STATUS_FIELD, STATUS_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String status;

    private final List<String> statusReasons;

    private DeleteGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
    }

    /**
     * <p>
     * The unique identifier of the deleted Gateway.
     * </p>
     * 
     * @return The unique identifier of the deleted Gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The current status of the Gateway deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway deletion.
     * @see GatewayStatus
     */
    public final GatewayStatus status() {
        return GatewayStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Gateway deletion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GatewayStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Gateway deletion.
     * @see GatewayStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusReasons() {
        return statusReasons != null && !(statusReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reasons for the current status of the Gateway deletion.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusReasons} method.
     * </p>
     * 
     * @return The reasons for the current status of the Gateway deletion.
     */
    public final List<String> statusReasons() {
        return statusReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusReasons() ? statusReasons() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayResponse)) {
            return false;
        }
        DeleteGatewayResponse other = (DeleteGatewayResponse) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasStatusReasons() == other.hasStatusReasons() && Objects.equals(statusReasons(), other.statusReasons());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGatewayResponse").add("GatewayId", gatewayId()).add("Status", statusAsString())
                .add("StatusReasons", hasStatusReasons() ? statusReasons() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReasons":
            return Optional.ofNullable(clazz.cast(statusReasons()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayResponse, T> g) {
        return obj -> g.apply((DeleteGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteGatewayResponse> {
        /**
         * <p>
         * The unique identifier of the deleted Gateway.
         * </p>
         * 
         * @param gatewayId
         *        The unique identifier of the deleted Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The current status of the Gateway deletion.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway deletion.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Gateway deletion.
         * </p>
         * 
         * @param status
         *        The current status of the Gateway deletion.
         * @see GatewayStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayStatus
         */
        Builder status(GatewayStatus status);

        /**
         * <p>
         * The reasons for the current status of the Gateway deletion.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(Collection<String> statusReasons);

        /**
         * <p>
         * The reasons for the current status of the Gateway deletion.
         * </p>
         * 
         * @param statusReasons
         *        The reasons for the current status of the Gateway deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReasons(String... statusReasons);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlResponse.BuilderImpl implements Builder {
        private String gatewayId;

        private String status;

        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayResponse model) {
            super(model);
            gatewayId(model.gatewayId);
            status(model.status);
            statusReasons(model.statusReasons);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GatewayStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = StatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String... statusReasons) {
            statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        public DeleteGatewayResponse build() {
            return new DeleteGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
