/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayTargetRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<CreateGatewayTargetRequest.Builder, CreateGatewayTargetRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayIdentifier").getter(getter(CreateGatewayTargetRequest::gatewayIdentifier))
            .setter(setter(Builder::gatewayIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGatewayTargetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateGatewayTargetRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateGatewayTargetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("targetConfiguration")
            .getter(getter(CreateGatewayTargetRequest::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build())
            .build();

    private static final SdkField<List<CredentialProviderConfiguration>> CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD = SdkField
            .<List<CredentialProviderConfiguration>> builder(MarshallingType.LIST)
            .memberName("credentialProviderConfigurations")
            .getter(getter(CreateGatewayTargetRequest::credentialProviderConfigurations))
            .setter(setter(Builder::credentialProviderConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CredentialProviderConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CredentialProviderConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TARGET_CONFIGURATION_FIELD,
            CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayIdentifier;

    private final String name;

    private final String description;

    private final String clientToken;

    private final TargetConfiguration targetConfiguration;

    private final List<CredentialProviderConfiguration> credentialProviderConfigurations;

    private CreateGatewayTargetRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.targetConfiguration = builder.targetConfiguration;
        this.credentialProviderConfigurations = builder.credentialProviderConfigurations;
    }

    /**
     * <p>
     * The identifier of the gateway to create a target for. This can be either the gateway ID or the gateway ARN.
     * </p>
     * 
     * @return The identifier of the gateway to create a target for. This can be either the gateway ID or the gateway
     *         ARN.
     */
    public final String gatewayIdentifier() {
        return gatewayIdentifier;
    }

    /**
     * <p>
     * The name of the gateway target. The name must be unique within the gateway.
     * </p>
     * 
     * @return The name of the gateway target. The name must be unique within the gateway.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the gateway target.
     * </p>
     * 
     * @return The description of the gateway target.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request but does not return an error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration settings for the target, including endpoint information and schema definitions.
     * </p>
     * 
     * @return The configuration settings for the target, including endpoint information and schema definitions.
     */
    public final TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CredentialProviderConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCredentialProviderConfigurations() {
        return credentialProviderConfigurations != null && !(credentialProviderConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The credential provider configurations for the target. These configurations specify how the gateway authenticates
     * with the target endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCredentialProviderConfigurations}
     * method.
     * </p>
     * 
     * @return The credential provider configurations for the target. These configurations specify how the gateway
     *         authenticates with the target endpoint.
     */
    public final List<CredentialProviderConfiguration> credentialProviderConfigurations() {
        return credentialProviderConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCredentialProviderConfigurations() ? credentialProviderConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayTargetRequest)) {
            return false;
        }
        CreateGatewayTargetRequest other = (CreateGatewayTargetRequest) obj;
        return Objects.equals(gatewayIdentifier(), other.gatewayIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(targetConfiguration(), other.targetConfiguration())
                && hasCredentialProviderConfigurations() == other.hasCredentialProviderConfigurations()
                && Objects.equals(credentialProviderConfigurations(), other.credentialProviderConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateGatewayTargetRequest")
                .add("GatewayIdentifier", gatewayIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientToken", clientToken())
                .add("TargetConfiguration", targetConfiguration())
                .add("CredentialProviderConfigurations",
                        hasCredentialProviderConfigurations() ? credentialProviderConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayIdentifier":
            return Optional.ofNullable(clazz.cast(gatewayIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "targetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        case "credentialProviderConfigurations":
            return Optional.ofNullable(clazz.cast(credentialProviderConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("credentialProviderConfigurations", CREDENTIAL_PROVIDER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayTargetRequest, T> g) {
        return obj -> g.apply((CreateGatewayTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGatewayTargetRequest> {
        /**
         * <p>
         * The identifier of the gateway to create a target for. This can be either the gateway ID or the gateway ARN.
         * </p>
         * 
         * @param gatewayIdentifier
         *        The identifier of the gateway to create a target for. This can be either the gateway ID or the gateway
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayIdentifier(String gatewayIdentifier);

        /**
         * <p>
         * The name of the gateway target. The name must be unique within the gateway.
         * </p>
         * 
         * @param name
         *        The name of the gateway target. The name must be unique within the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the gateway target.
         * </p>
         * 
         * @param description
         *        The description of the gateway target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request but does not return an error.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings for the target, including endpoint information and schema definitions.
         * </p>
         * 
         * @param targetConfiguration
         *        The configuration settings for the target, including endpoint information and schema definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * <p>
         * The configuration settings for the target, including endpoint information and schema definitions.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetConfiguration.Builder} avoiding the
         * need to create one manually via {@link TargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        /**
         * <p>
         * The credential provider configurations for the target. These configurations specify how the gateway
         * authenticates with the target endpoint.
         * </p>
         * 
         * @param credentialProviderConfigurations
         *        The credential provider configurations for the target. These configurations specify how the gateway
         *        authenticates with the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProviderConfigurations(Collection<CredentialProviderConfiguration> credentialProviderConfigurations);

        /**
         * <p>
         * The credential provider configurations for the target. These configurations specify how the gateway
         * authenticates with the target endpoint.
         * </p>
         * 
         * @param credentialProviderConfigurations
         *        The credential provider configurations for the target. These configurations specify how the gateway
         *        authenticates with the target endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialProviderConfigurations(CredentialProviderConfiguration... credentialProviderConfigurations);

        /**
         * <p>
         * The credential provider configurations for the target. These configurations specify how the gateway
         * authenticates with the target endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #credentialProviderConfigurations(List<CredentialProviderConfiguration>)}.
         * 
         * @param credentialProviderConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentialProviderConfigurations(java.util.Collection<CredentialProviderConfiguration>)
         */
        Builder credentialProviderConfigurations(
                Consumer<CredentialProviderConfiguration.Builder>... credentialProviderConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String gatewayIdentifier;

        private String name;

        private String description;

        private String clientToken;

        private TargetConfiguration targetConfiguration;

        private List<CredentialProviderConfiguration> credentialProviderConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayTargetRequest model) {
            super(model);
            gatewayIdentifier(model.gatewayIdentifier);
            name(model.name);
            description(model.description);
            clientToken(model.clientToken);
            targetConfiguration(model.targetConfiguration);
            credentialProviderConfigurations(model.credentialProviderConfigurations);
        }

        public final String getGatewayIdentifier() {
            return gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final List<CredentialProviderConfiguration.Builder> getCredentialProviderConfigurations() {
            List<CredentialProviderConfiguration.Builder> result = CredentialProviderConfigurationsCopier
                    .copyToBuilder(this.credentialProviderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviderConfigurations(
                Collection<CredentialProviderConfiguration.BuilderImpl> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier
                    .copyFromBuilder(credentialProviderConfigurations);
        }

        @Override
        public final Builder credentialProviderConfigurations(
                Collection<CredentialProviderConfiguration> credentialProviderConfigurations) {
            this.credentialProviderConfigurations = CredentialProviderConfigurationsCopier.copy(credentialProviderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(CredentialProviderConfiguration... credentialProviderConfigurations) {
            credentialProviderConfigurations(Arrays.asList(credentialProviderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviderConfigurations(
                Consumer<CredentialProviderConfiguration.Builder>... credentialProviderConfigurations) {
            credentialProviderConfigurations(Stream.of(credentialProviderConfigurations)
                    .map(c -> CredentialProviderConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGatewayTargetRequest build() {
            return new CreateGatewayTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
