/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The artifact of the agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentArtifact implements SdkPojo, Serializable, ToCopyableBuilder<AgentArtifact.Builder, AgentArtifact> {
    private static final SdkField<ContainerConfiguration> CONTAINER_CONFIGURATION_FIELD = SdkField
            .<ContainerConfiguration> builder(MarshallingType.SDK_POJO).memberName("containerConfiguration")
            .getter(getter(AgentArtifact::containerConfiguration)).setter(setter(Builder::containerConfiguration))
            .constructor(ContainerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONTAINER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContainerConfiguration containerConfiguration;

    private final Type type;

    private AgentArtifact(BuilderImpl builder) {
        this.containerConfiguration = builder.containerConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The container configuration for the agent artifact.
     * </p>
     * 
     * @return The container configuration for the agent artifact.
     */
    public final ContainerConfiguration containerConfiguration() {
        return containerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentArtifact)) {
            return false;
        }
        AgentArtifact other = (AgentArtifact) obj;
        return Objects.equals(containerConfiguration(), other.containerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentArtifact").add("ContainerConfiguration", containerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerConfiguration":
            return Optional.ofNullable(clazz.cast(containerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #containerConfiguration()} initialized to the given value.
     *
     * <p>
     * The container configuration for the agent artifact.
     * </p>
     * 
     * @param containerConfiguration
     *        The container configuration for the agent artifact.
     */
    public static AgentArtifact fromContainerConfiguration(ContainerConfiguration containerConfiguration) {
        return builder().containerConfiguration(containerConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #containerConfiguration()} initialized to the given value.
     *
     * <p>
     * The container configuration for the agent artifact.
     * </p>
     * 
     * @param containerConfiguration
     *        The container configuration for the agent artifact.
     */
    public static AgentArtifact fromContainerConfiguration(Consumer<ContainerConfiguration.Builder> containerConfiguration) {
        ContainerConfiguration.Builder builder = ContainerConfiguration.builder();
        containerConfiguration.accept(builder);
        return fromContainerConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerConfiguration", CONTAINER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentArtifact, T> g) {
        return obj -> g.apply((AgentArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentArtifact> {
        /**
         * <p>
         * The container configuration for the agent artifact.
         * </p>
         * 
         * @param containerConfiguration
         *        The container configuration for the agent artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerConfiguration(ContainerConfiguration containerConfiguration);

        /**
         * <p>
         * The container configuration for the agent artifact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerConfiguration.Builder} avoiding
         * the need to create one manually via {@link ContainerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #containerConfiguration(ContainerConfiguration)}.
         * 
         * @param containerConfiguration
         *        a consumer that will call methods on {@link ContainerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerConfiguration(ContainerConfiguration)
         */
        default Builder containerConfiguration(Consumer<ContainerConfiguration.Builder> containerConfiguration) {
            return containerConfiguration(ContainerConfiguration.builder().applyMutation(containerConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerConfiguration containerConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AgentArtifact model) {
            containerConfiguration(model.containerConfiguration);
        }

        public final ContainerConfiguration.Builder getContainerConfiguration() {
            return containerConfiguration != null ? containerConfiguration.toBuilder() : null;
        }

        public final void setContainerConfiguration(ContainerConfiguration.BuilderImpl containerConfiguration) {
            Object oldValue = this.containerConfiguration;
            this.containerConfiguration = containerConfiguration != null ? containerConfiguration.build() : null;
            handleUnionValueChange(Type.CONTAINER_CONFIGURATION, oldValue, this.containerConfiguration);
        }

        @Override
        public final Builder containerConfiguration(ContainerConfiguration containerConfiguration) {
            Object oldValue = this.containerConfiguration;
            this.containerConfiguration = containerConfiguration;
            handleUnionValueChange(Type.CONTAINER_CONFIGURATION, oldValue, this.containerConfiguration);
            return this;
        }

        @Override
        public AgentArtifact build() {
            return new AgentArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AgentArtifact#type()
     */
    public enum Type {
        CONTAINER_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
