/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Agent;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListAgentRuntimesResponse;

public class ListAgentRuntimesIterable
implements SdkIterable<ListAgentRuntimesResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListAgentRuntimesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentRuntimesIterable(BedrockAgentCoreControlClient client, ListAgentRuntimesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentRuntimesResponseFetcher();
    }

    public Iterator<ListAgentRuntimesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Agent> agentRuntimes() {
        Function<ListAgentRuntimesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentRuntimes() != null) {
                return response.agentRuntimes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentRuntimesResponseFetcher
    implements SyncPageFetcher<ListAgentRuntimesResponse> {
        private ListAgentRuntimesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentRuntimesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentRuntimesResponse nextPage(ListAgentRuntimesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentRuntimesIterable.this.client.listAgentRuntimes(ListAgentRuntimesIterable.this.firstRequest);
            }
            return ListAgentRuntimesIterable.this.client.listAgentRuntimes((ListAgentRuntimesRequest)((Object)ListAgentRuntimesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

