/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an agent runtime. An agent runtime is the execution environment for a Amazon Bedrock
 * Agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Agent implements SdkPojo, Serializable, ToCopyableBuilder<Agent.Builder, Agent> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeArn").getter(getter(Agent::agentRuntimeArn)).setter(setter(Builder::agentRuntimeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeId").getter(getter(Agent::agentRuntimeId)).setter(setter(Builder::agentRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()).build();

    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeVersion").getter(getter(Agent::agentRuntimeVersion))
            .setter(setter(Builder::agentRuntimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build())
            .build();

    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeName").getter(getter(Agent::agentRuntimeName)).setter(setter(Builder::agentRuntimeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Agent::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(Agent::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Agent::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD,
            AGENT_RUNTIME_ID_FIELD, AGENT_RUNTIME_VERSION_FIELD, AGENT_RUNTIME_NAME_FIELD, DESCRIPTION_FIELD,
            LAST_UPDATED_AT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentRuntimeArn;

    private final String agentRuntimeId;

    private final String agentRuntimeVersion;

    private final String agentRuntimeName;

    private final String description;

    private final Instant lastUpdatedAt;

    private final String status;

    private Agent(BuilderImpl builder) {
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.agentRuntimeName = builder.agentRuntimeName;
        this.description = builder.description;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent runtime.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent runtime.
     */
    public final String agentRuntimeArn() {
        return agentRuntimeArn;
    }

    /**
     * <p>
     * The unique identifier of the agent runtime.
     * </p>
     * 
     * @return The unique identifier of the agent runtime.
     */
    public final String agentRuntimeId() {
        return agentRuntimeId;
    }

    /**
     * <p>
     * The version of the agent runtime.
     * </p>
     * 
     * @return The version of the agent runtime.
     */
    public final String agentRuntimeVersion() {
        return agentRuntimeVersion;
    }

    /**
     * <p>
     * The name of the agent runtime.
     * </p>
     * 
     * @return The name of the agent runtime.
     */
    public final String agentRuntimeName() {
        return agentRuntimeName;
    }

    /**
     * <p>
     * The description of the agent runtime.
     * </p>
     * 
     * @return The description of the agent runtime.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp when the agent runtime was last updated.
     * </p>
     * 
     * @return The timestamp when the agent runtime was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The current status of the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the agent runtime.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the agent runtime.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Agent)) {
            return false;
        }
        Agent other = (Agent) obj;
        return Objects.equals(agentRuntimeArn(), other.agentRuntimeArn())
                && Objects.equals(agentRuntimeId(), other.agentRuntimeId())
                && Objects.equals(agentRuntimeVersion(), other.agentRuntimeVersion())
                && Objects.equals(agentRuntimeName(), other.agentRuntimeName())
                && Objects.equals(description(), other.description()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Agent").add("AgentRuntimeArn", agentRuntimeArn()).add("AgentRuntimeId", agentRuntimeId())
                .add("AgentRuntimeVersion", agentRuntimeVersion()).add("AgentRuntimeName", agentRuntimeName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastUpdatedAt", lastUpdatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeArn":
            return Optional.ofNullable(clazz.cast(agentRuntimeArn()));
        case "agentRuntimeId":
            return Optional.ofNullable(clazz.cast(agentRuntimeId()));
        case "agentRuntimeVersion":
            return Optional.ofNullable(clazz.cast(agentRuntimeVersion()));
        case "agentRuntimeName":
            return Optional.ofNullable(clazz.cast(agentRuntimeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Agent, T> g) {
        return obj -> g.apply((Agent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Agent> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeArn
         *        The Amazon Resource Name (ARN) of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArn(String agentRuntimeArn);

        /**
         * <p>
         * The unique identifier of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeId
         *        The unique identifier of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeId(String agentRuntimeId);

        /**
         * <p>
         * The version of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeVersion
         *        The version of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeVersion(String agentRuntimeVersion);

        /**
         * <p>
         * The name of the agent runtime.
         * </p>
         * 
         * @param agentRuntimeName
         *        The name of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeName(String agentRuntimeName);

        /**
         * <p>
         * The description of the agent runtime.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp when the agent runtime was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the agent runtime was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The current status of the agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the agent runtime.
         * </p>
         * 
         * @param status
         *        The current status of the agent runtime.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String agentRuntimeArn;

        private String agentRuntimeId;

        private String agentRuntimeVersion;

        private String agentRuntimeName;

        private String description;

        private Instant lastUpdatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Agent model) {
            agentRuntimeArn(model.agentRuntimeArn);
            agentRuntimeId(model.agentRuntimeId);
            agentRuntimeVersion(model.agentRuntimeVersion);
            agentRuntimeName(model.agentRuntimeName);
            description(model.description);
            lastUpdatedAt(model.lastUpdatedAt);
            status(model.status);
        }

        public final String getAgentRuntimeArn() {
            return agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getAgentRuntimeId() {
            return agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final String getAgentRuntimeName() {
            return agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Agent build() {
            return new Agent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
