/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Model Context Protocol (MCP) configuration for a target. This structure defines how the gateway uses MCP to
 * communicate with the target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class McpTargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<McpTargetConfiguration.Builder, McpTargetConfiguration> {
    private static final SdkField<ApiSchemaConfiguration> OPEN_API_SCHEMA_FIELD = SdkField
            .<ApiSchemaConfiguration> builder(MarshallingType.SDK_POJO).memberName("openApiSchema")
            .getter(getter(McpTargetConfiguration::openApiSchema)).setter(setter(Builder::openApiSchema))
            .constructor(ApiSchemaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openApiSchema").build()).build();

    private static final SdkField<ApiSchemaConfiguration> SMITHY_MODEL_FIELD = SdkField
            .<ApiSchemaConfiguration> builder(MarshallingType.SDK_POJO).memberName("smithyModel")
            .getter(getter(McpTargetConfiguration::smithyModel)).setter(setter(Builder::smithyModel))
            .constructor(ApiSchemaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smithyModel").build()).build();

    private static final SdkField<McpLambdaTargetConfiguration> LAMBDA_FIELD = SdkField
            .<McpLambdaTargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("lambda")
            .getter(getter(McpTargetConfiguration::lambda)).setter(setter(Builder::lambda))
            .constructor(McpLambdaTargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_API_SCHEMA_FIELD,
            SMITHY_MODEL_FIELD, LAMBDA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ApiSchemaConfiguration openApiSchema;

    private final ApiSchemaConfiguration smithyModel;

    private final McpLambdaTargetConfiguration lambda;

    private final Type type;

    private McpTargetConfiguration(BuilderImpl builder) {
        this.openApiSchema = builder.openApiSchema;
        this.smithyModel = builder.smithyModel;
        this.lambda = builder.lambda;
        this.type = builder.type;
    }

    /**
     * <p>
     * The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the target.
     * </p>
     * 
     * @return The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
     *         target.
     */
    public final ApiSchemaConfiguration openApiSchema() {
        return openApiSchema;
    }

    /**
     * <p>
     * The Smithy model for the Model Context Protocol target. This model defines the API structure of the target using
     * the Smithy specification.
     * </p>
     * 
     * @return The Smithy model for the Model Context Protocol target. This model defines the API structure of the
     *         target using the Smithy specification.
     */
    public final ApiSchemaConfiguration smithyModel() {
        return smithyModel;
    }

    /**
     * <p>
     * The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway uses a
     * Lambda function to communicate with the target.
     * </p>
     * 
     * @return The Lambda configuration for the Model Context Protocol target. This configuration defines how the
     *         gateway uses a Lambda function to communicate with the target.
     */
    public final McpLambdaTargetConfiguration lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(openApiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(smithyModel());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof McpTargetConfiguration)) {
            return false;
        }
        McpTargetConfiguration other = (McpTargetConfiguration) obj;
        return Objects.equals(openApiSchema(), other.openApiSchema()) && Objects.equals(smithyModel(), other.smithyModel())
                && Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("McpTargetConfiguration").add("OpenApiSchema", openApiSchema()).add("SmithyModel", smithyModel())
                .add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "openApiSchema":
            return Optional.ofNullable(clazz.cast(openApiSchema()));
        case "smithyModel":
            return Optional.ofNullable(clazz.cast(smithyModel()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #openApiSchema()} initialized to the given value.
     *
     * <p>
     * The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the target.
     * </p>
     * 
     * @param openApiSchema
     *        The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
     *        target.
     */
    public static McpTargetConfiguration fromOpenApiSchema(ApiSchemaConfiguration openApiSchema) {
        return builder().openApiSchema(openApiSchema).build();
    }

    /**
     * Create an instance of this class with {@link #openApiSchema()} initialized to the given value.
     *
     * <p>
     * The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the target.
     * </p>
     * 
     * @param openApiSchema
     *        The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
     *        target.
     */
    public static McpTargetConfiguration fromOpenApiSchema(Consumer<ApiSchemaConfiguration.Builder> openApiSchema) {
        ApiSchemaConfiguration.Builder builder = ApiSchemaConfiguration.builder();
        openApiSchema.accept(builder);
        return fromOpenApiSchema(builder.build());
    }

    /**
     * Create an instance of this class with {@link #smithyModel()} initialized to the given value.
     *
     * <p>
     * The Smithy model for the Model Context Protocol target. This model defines the API structure of the target using
     * the Smithy specification.
     * </p>
     * 
     * @param smithyModel
     *        The Smithy model for the Model Context Protocol target. This model defines the API structure of the target
     *        using the Smithy specification.
     */
    public static McpTargetConfiguration fromSmithyModel(ApiSchemaConfiguration smithyModel) {
        return builder().smithyModel(smithyModel).build();
    }

    /**
     * Create an instance of this class with {@link #smithyModel()} initialized to the given value.
     *
     * <p>
     * The Smithy model for the Model Context Protocol target. This model defines the API structure of the target using
     * the Smithy specification.
     * </p>
     * 
     * @param smithyModel
     *        The Smithy model for the Model Context Protocol target. This model defines the API structure of the target
     *        using the Smithy specification.
     */
    public static McpTargetConfiguration fromSmithyModel(Consumer<ApiSchemaConfiguration.Builder> smithyModel) {
        ApiSchemaConfiguration.Builder builder = ApiSchemaConfiguration.builder();
        smithyModel.accept(builder);
        return fromSmithyModel(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lambda()} initialized to the given value.
     *
     * <p>
     * The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway uses a
     * Lambda function to communicate with the target.
     * </p>
     * 
     * @param lambda
     *        The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway
     *        uses a Lambda function to communicate with the target.
     */
    public static McpTargetConfiguration fromLambda(McpLambdaTargetConfiguration lambda) {
        return builder().lambda(lambda).build();
    }

    /**
     * Create an instance of this class with {@link #lambda()} initialized to the given value.
     *
     * <p>
     * The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway uses a
     * Lambda function to communicate with the target.
     * </p>
     * 
     * @param lambda
     *        The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway
     *        uses a Lambda function to communicate with the target.
     */
    public static McpTargetConfiguration fromLambda(Consumer<McpLambdaTargetConfiguration.Builder> lambda) {
        McpLambdaTargetConfiguration.Builder builder = McpLambdaTargetConfiguration.builder();
        lambda.accept(builder);
        return fromLambda(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("openApiSchema", OPEN_API_SCHEMA_FIELD);
        map.put("smithyModel", SMITHY_MODEL_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<McpTargetConfiguration, T> g) {
        return obj -> g.apply((McpTargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, McpTargetConfiguration> {
        /**
         * <p>
         * The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
         * target.
         * </p>
         * 
         * @param openApiSchema
         *        The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
         *        target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openApiSchema(ApiSchemaConfiguration openApiSchema);

        /**
         * <p>
         * The OpenAPI schema for the Model Context Protocol target. This schema defines the API structure of the
         * target.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiSchemaConfiguration.Builder} avoiding
         * the need to create one manually via {@link ApiSchemaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiSchemaConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #openApiSchema(ApiSchemaConfiguration)}.
         * 
         * @param openApiSchema
         *        a consumer that will call methods on {@link ApiSchemaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openApiSchema(ApiSchemaConfiguration)
         */
        default Builder openApiSchema(Consumer<ApiSchemaConfiguration.Builder> openApiSchema) {
            return openApiSchema(ApiSchemaConfiguration.builder().applyMutation(openApiSchema).build());
        }

        /**
         * <p>
         * The Smithy model for the Model Context Protocol target. This model defines the API structure of the target
         * using the Smithy specification.
         * </p>
         * 
         * @param smithyModel
         *        The Smithy model for the Model Context Protocol target. This model defines the API structure of the
         *        target using the Smithy specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smithyModel(ApiSchemaConfiguration smithyModel);

        /**
         * <p>
         * The Smithy model for the Model Context Protocol target. This model defines the API structure of the target
         * using the Smithy specification.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiSchemaConfiguration.Builder} avoiding
         * the need to create one manually via {@link ApiSchemaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiSchemaConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #smithyModel(ApiSchemaConfiguration)}.
         * 
         * @param smithyModel
         *        a consumer that will call methods on {@link ApiSchemaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smithyModel(ApiSchemaConfiguration)
         */
        default Builder smithyModel(Consumer<ApiSchemaConfiguration.Builder> smithyModel) {
            return smithyModel(ApiSchemaConfiguration.builder().applyMutation(smithyModel).build());
        }

        /**
         * <p>
         * The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway
         * uses a Lambda function to communicate with the target.
         * </p>
         * 
         * @param lambda
         *        The Lambda configuration for the Model Context Protocol target. This configuration defines how the
         *        gateway uses a Lambda function to communicate with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(McpLambdaTargetConfiguration lambda);

        /**
         * <p>
         * The Lambda configuration for the Model Context Protocol target. This configuration defines how the gateway
         * uses a Lambda function to communicate with the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link McpLambdaTargetConfiguration.Builder}
         * avoiding the need to create one manually via {@link McpLambdaTargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link McpLambdaTargetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lambda(McpLambdaTargetConfiguration)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link McpLambdaTargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(McpLambdaTargetConfiguration)
         */
        default Builder lambda(Consumer<McpLambdaTargetConfiguration.Builder> lambda) {
            return lambda(McpLambdaTargetConfiguration.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApiSchemaConfiguration openApiSchema;

        private ApiSchemaConfiguration smithyModel;

        private McpLambdaTargetConfiguration lambda;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(McpTargetConfiguration model) {
            openApiSchema(model.openApiSchema);
            smithyModel(model.smithyModel);
            lambda(model.lambda);
        }

        public final ApiSchemaConfiguration.Builder getOpenApiSchema() {
            return openApiSchema != null ? openApiSchema.toBuilder() : null;
        }

        public final void setOpenApiSchema(ApiSchemaConfiguration.BuilderImpl openApiSchema) {
            Object oldValue = this.openApiSchema;
            this.openApiSchema = openApiSchema != null ? openApiSchema.build() : null;
            handleUnionValueChange(Type.OPEN_API_SCHEMA, oldValue, this.openApiSchema);
        }

        @Override
        public final Builder openApiSchema(ApiSchemaConfiguration openApiSchema) {
            Object oldValue = this.openApiSchema;
            this.openApiSchema = openApiSchema;
            handleUnionValueChange(Type.OPEN_API_SCHEMA, oldValue, this.openApiSchema);
            return this;
        }

        public final ApiSchemaConfiguration.Builder getSmithyModel() {
            return smithyModel != null ? smithyModel.toBuilder() : null;
        }

        public final void setSmithyModel(ApiSchemaConfiguration.BuilderImpl smithyModel) {
            Object oldValue = this.smithyModel;
            this.smithyModel = smithyModel != null ? smithyModel.build() : null;
            handleUnionValueChange(Type.SMITHY_MODEL, oldValue, this.smithyModel);
        }

        @Override
        public final Builder smithyModel(ApiSchemaConfiguration smithyModel) {
            Object oldValue = this.smithyModel;
            this.smithyModel = smithyModel;
            handleUnionValueChange(Type.SMITHY_MODEL, oldValue, this.smithyModel);
            return this;
        }

        public final McpLambdaTargetConfiguration.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(McpLambdaTargetConfiguration.BuilderImpl lambda) {
            Object oldValue = this.lambda;
            this.lambda = lambda != null ? lambda.build() : null;
            handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(McpLambdaTargetConfiguration lambda) {
            Object oldValue = this.lambda;
            this.lambda = lambda;
            handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        @Override
        public McpTargetConfiguration build() {
            return new McpTargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see McpTargetConfiguration#type()
     */
    public enum Type {
        OPEN_API_SCHEMA,

        SMITHY_MODEL,

        LAMBDA,

        UNKNOWN_TO_SDK_VERSION
    }
}
