/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a gateway protocol. This structure defines how the gateway communicates with external services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewayProtocolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GatewayProtocolConfiguration.Builder, GatewayProtocolConfiguration> {
    private static final SdkField<MCPGatewayConfiguration> MCP_FIELD = SdkField
            .<MCPGatewayConfiguration> builder(MarshallingType.SDK_POJO).memberName("mcp")
            .getter(getter(GatewayProtocolConfiguration::mcp)).setter(setter(Builder::mcp))
            .constructor(MCPGatewayConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MCPGatewayConfiguration mcp;

    private final Type type;

    private GatewayProtocolConfiguration(BuilderImpl builder) {
        this.mcp = builder.mcp;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
     * Bedrock Agent and external tools.
     * </p>
     * 
     * @return The configuration for the Model Context Protocol (MCP). This protocol enables communication between
     *         Amazon Bedrock Agent and external tools.
     */
    public final MCPGatewayConfiguration mcp() {
        return mcp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayProtocolConfiguration)) {
            return false;
        }
        GatewayProtocolConfiguration other = (GatewayProtocolConfiguration) obj;
        return Objects.equals(mcp(), other.mcp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GatewayProtocolConfiguration").add("Mcp", mcp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mcp":
            return Optional.ofNullable(clazz.cast(mcp()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #mcp()} initialized to the given value.
     *
     * <p>
     * The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
     * Bedrock Agent and external tools.
     * </p>
     * 
     * @param mcp
     *        The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
     *        Bedrock Agent and external tools.
     */
    public static GatewayProtocolConfiguration fromMcp(MCPGatewayConfiguration mcp) {
        return builder().mcp(mcp).build();
    }

    /**
     * Create an instance of this class with {@link #mcp()} initialized to the given value.
     *
     * <p>
     * The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
     * Bedrock Agent and external tools.
     * </p>
     * 
     * @param mcp
     *        The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
     *        Bedrock Agent and external tools.
     */
    public static GatewayProtocolConfiguration fromMcp(Consumer<MCPGatewayConfiguration.Builder> mcp) {
        MCPGatewayConfiguration.Builder builder = MCPGatewayConfiguration.builder();
        mcp.accept(builder);
        return fromMcp(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mcp", MCP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayProtocolConfiguration, T> g) {
        return obj -> g.apply((GatewayProtocolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewayProtocolConfiguration> {
        /**
         * <p>
         * The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
         * Bedrock Agent and external tools.
         * </p>
         * 
         * @param mcp
         *        The configuration for the Model Context Protocol (MCP). This protocol enables communication between
         *        Amazon Bedrock Agent and external tools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcp(MCPGatewayConfiguration mcp);

        /**
         * <p>
         * The configuration for the Model Context Protocol (MCP). This protocol enables communication between Amazon
         * Bedrock Agent and external tools.
         * </p>
         * This is a convenience method that creates an instance of the {@link MCPGatewayConfiguration.Builder} avoiding
         * the need to create one manually via {@link MCPGatewayConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MCPGatewayConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #mcp(MCPGatewayConfiguration)}.
         * 
         * @param mcp
         *        a consumer that will call methods on {@link MCPGatewayConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mcp(MCPGatewayConfiguration)
         */
        default Builder mcp(Consumer<MCPGatewayConfiguration.Builder> mcp) {
            return mcp(MCPGatewayConfiguration.builder().applyMutation(mcp).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MCPGatewayConfiguration mcp;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayProtocolConfiguration model) {
            mcp(model.mcp);
        }

        public final MCPGatewayConfiguration.Builder getMcp() {
            return mcp != null ? mcp.toBuilder() : null;
        }

        public final void setMcp(MCPGatewayConfiguration.BuilderImpl mcp) {
            Object oldValue = this.mcp;
            this.mcp = mcp != null ? mcp.build() : null;
            handleUnionValueChange(Type.MCP, oldValue, this.mcp);
        }

        @Override
        public final Builder mcp(MCPGatewayConfiguration mcp) {
            Object oldValue = this.mcp;
            this.mcp = mcp;
            handleUnionValueChange(Type.MCP, oldValue, this.mcp);
            return this;
        }

        @Override
        public GatewayProtocolConfiguration build() {
            return new GatewayProtocolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GatewayProtocolConfiguration#type()
     */
    public enum Type {
        MCP,

        UNKNOWN_TO_SDK_VERSION
    }
}
