/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentRuntimeRequest extends BedrockAgentCoreControlRequest implements
        ToCopyableBuilder<CreateAgentRuntimeRequest.Builder, CreateAgentRuntimeRequest> {
    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentRuntimeName").getter(getter(CreateAgentRuntimeRequest::agentRuntimeName))
            .setter(setter(Builder::agentRuntimeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAgentRuntimeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AgentArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField
            .<AgentArtifact> builder(MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact")
            .getter(getter(CreateAgentRuntimeRequest::agentRuntimeArtifact)).setter(setter(Builder::agentRuntimeArtifact))
            .constructor(AgentArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateAgentRuntimeRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(CreateAgentRuntimeRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField
            .<ProtocolConfiguration> builder(MarshallingType.SDK_POJO).memberName("protocolConfiguration")
            .getter(getter(CreateAgentRuntimeRequest::protocolConfiguration)).setter(setter(Builder::protocolConfiguration))
            .constructor(ProtocolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAgentRuntimeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(CreateAgentRuntimeRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField
            .<AuthorizerConfiguration> builder(MarshallingType.SDK_POJO).memberName("authorizerConfiguration")
            .getter(getter(CreateAgentRuntimeRequest::authorizerConfiguration)).setter(setter(Builder::authorizerConfiguration))
            .constructor(AuthorizerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_NAME_FIELD,
            DESCRIPTION_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD,
            PROTOCOL_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ENVIRONMENT_VARIABLES_FIELD, AUTHORIZER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentRuntimeName;

    private final String description;

    private final AgentArtifact agentRuntimeArtifact;

    private final String roleArn;

    private final NetworkConfiguration networkConfiguration;

    private final ProtocolConfiguration protocolConfiguration;

    private final String clientToken;

    private final Map<String, String> environmentVariables;

    private final AuthorizerConfiguration authorizerConfiguration;

    private CreateAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeName = builder.agentRuntimeName;
        this.description = builder.description;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.clientToken = builder.clientToken;
        this.environmentVariables = builder.environmentVariables;
        this.authorizerConfiguration = builder.authorizerConfiguration;
    }

    /**
     * <p>
     * The name of the secure agent.
     * </p>
     * 
     * @return The name of the secure agent.
     */
    public final String agentRuntimeName() {
        return agentRuntimeName;
    }

    /**
     * <p>
     * The description of the agent runtime.
     * </p>
     * 
     * @return The description of the agent runtime.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The artifact of the agent.
     * </p>
     * 
     * @return The artifact of the agent.
     */
    public final AgentArtifact agentRuntimeArtifact() {
        return agentRuntimeArtifact;
    }

    /**
     * <p>
     * The IAM role ARN that provides permissions for the agent runtime.
     * </p>
     * 
     * @return The IAM role ARN that provides permissions for the agent runtime.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The network configuration for the agent runtime.
     * </p>
     * 
     * @return The network configuration for the agent runtime.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * Returns the value of the ProtocolConfiguration property for this object.
     * 
     * @return The value of the ProtocolConfiguration property for this object.
     */
    public final ProtocolConfiguration protocolConfiguration() {
        return protocolConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Environment variables to set in the agent runtime environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return Environment variables to set in the agent runtime environment.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The authorizer configuration for the agent runtime.
     * </p>
     * 
     * @return The authorizer configuration for the agent runtime.
     */
    public final AuthorizerConfiguration authorizerConfiguration() {
        return authorizerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRuntimeRequest)) {
            return false;
        }
        CreateAgentRuntimeRequest other = (CreateAgentRuntimeRequest) obj;
        return Objects.equals(agentRuntimeName(), other.agentRuntimeName()) && Objects.equals(description(), other.description())
                && Objects.equals(agentRuntimeArtifact(), other.agentRuntimeArtifact())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(protocolConfiguration(), other.protocolConfiguration())
                && Objects.equals(clientToken(), other.clientToken())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(authorizerConfiguration(), other.authorizerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentRuntimeRequest").add("AgentRuntimeName", agentRuntimeName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AgentRuntimeArtifact", agentRuntimeArtifact()).add("RoleArn", roleArn())
                .add("NetworkConfiguration", networkConfiguration()).add("ProtocolConfiguration", protocolConfiguration())
                .add("ClientToken", clientToken())
                .add("EnvironmentVariables", environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthorizerConfiguration", authorizerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentRuntimeName":
            return Optional.ofNullable(clazz.cast(agentRuntimeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "agentRuntimeArtifact":
            return Optional.ofNullable(clazz.cast(agentRuntimeArtifact()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "protocolConfiguration":
            return Optional.ofNullable(clazz.cast(protocolConfiguration()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "authorizerConfiguration":
            return Optional.ofNullable(clazz.cast(authorizerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRuntimeRequest, T> g) {
        return obj -> g.apply((CreateAgentRuntimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAgentRuntimeRequest> {
        /**
         * <p>
         * The name of the secure agent.
         * </p>
         * 
         * @param agentRuntimeName
         *        The name of the secure agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeName(String agentRuntimeName);

        /**
         * <p>
         * The description of the agent runtime.
         * </p>
         * 
         * @param description
         *        The description of the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The artifact of the agent.
         * </p>
         * 
         * @param agentRuntimeArtifact
         *        The artifact of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentRuntimeArtifact(AgentArtifact agentRuntimeArtifact);

        /**
         * <p>
         * The artifact of the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentArtifact.Builder} avoiding the need
         * to create one manually via {@link AgentArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentArtifact.Builder#build()} is called immediately and its
         * result is passed to {@link #agentRuntimeArtifact(AgentArtifact)}.
         * 
         * @param agentRuntimeArtifact
         *        a consumer that will call methods on {@link AgentArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentRuntimeArtifact(AgentArtifact)
         */
        default Builder agentRuntimeArtifact(Consumer<AgentArtifact.Builder> agentRuntimeArtifact) {
            return agentRuntimeArtifact(AgentArtifact.builder().applyMutation(agentRuntimeArtifact).build());
        }

        /**
         * <p>
         * The IAM role ARN that provides permissions for the agent runtime.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN that provides permissions for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The network configuration for the agent runtime.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * @param protocolConfiguration
         *        The new value for the ProtocolConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration);

        /**
         * Sets the value of the ProtocolConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProtocolConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProtocolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtocolConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #protocolConfiguration(ProtocolConfiguration)}.
         * 
         * @param protocolConfiguration
         *        a consumer that will call methods on {@link ProtocolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocolConfiguration(ProtocolConfiguration)
         */
        default Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return protocolConfiguration(ProtocolConfiguration.builder().applyMutation(protocolConfiguration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Environment variables to set in the agent runtime environment.
         * </p>
         * 
         * @param environmentVariables
         *        Environment variables to set in the agent runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The authorizer configuration for the agent runtime.
         * </p>
         * 
         * @param authorizerConfiguration
         *        The authorizer configuration for the agent runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration);

        /**
         * <p>
         * The authorizer configuration for the agent runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AuthorizerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizerConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizerConfiguration(AuthorizerConfiguration)}.
         * 
         * @param authorizerConfiguration
         *        a consumer that will call methods on {@link AuthorizerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfiguration(AuthorizerConfiguration)
         */
        default Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return authorizerConfiguration(AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreControlRequest.BuilderImpl implements Builder {
        private String agentRuntimeName;

        private String description;

        private AgentArtifact agentRuntimeArtifact;

        private String roleArn;

        private NetworkConfiguration networkConfiguration;

        private ProtocolConfiguration protocolConfiguration;

        private String clientToken;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private AuthorizerConfiguration authorizerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRuntimeRequest model) {
            super(model);
            agentRuntimeName(model.agentRuntimeName);
            description(model.description);
            agentRuntimeArtifact(model.agentRuntimeArtifact);
            roleArn(model.roleArn);
            networkConfiguration(model.networkConfiguration);
            protocolConfiguration(model.protocolConfiguration);
            clientToken(model.clientToken);
            environmentVariables(model.environmentVariables);
            authorizerConfiguration(model.authorizerConfiguration);
        }

        public final String getAgentRuntimeName() {
            return agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AgentArtifact.Builder getAgentRuntimeArtifact() {
            return agentRuntimeArtifact != null ? agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return protocolConfiguration != null ? protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return authorizerConfiguration != null ? authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRuntimeRequest build() {
            return new CreateAgentRuntimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
